/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.AsconBaseDigest;
import org.bouncycastle.util.Pack;

public class AsconHash256
extends AsconBaseDigest {
    public AsconHash256() {
        this.reset();
    }

    @Override
    protected long pad(int i) {
        return 1L << (i << 3);
    }

    @Override
    protected long loadBytes(byte[] bytes, int inOff) {
        return Pack.littleEndianToLong(bytes, inOff);
    }

    @Override
    protected long loadBytes(byte[] bytes, int inOff, int n) {
        return Pack.littleEndianToLong(bytes, inOff, n);
    }

    @Override
    protected void setBytes(long w, byte[] bytes, int inOff) {
        Pack.longToLittleEndian(w, bytes, inOff);
    }

    @Override
    protected void setBytes(long w, byte[] bytes, int inOff, int n) {
        Pack.longToLittleEndian(w, bytes, inOff, n);
    }

    @Override
    public String getAlgorithmName() {
        return "Ascon-Hash256";
    }

    @Override
    public void reset() {
        super.reset();
        this.x0 = -7269279749984954751L;
        this.x1 = 5459383224871899602L;
        this.x2 = -5880230600644446182L;
        this.x3 = 4359436768738168243L;
        this.x4 = 1899470422303676269L;
    }
}

