/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.Blake2sDigest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class Blake2spDigest
implements ExtendedDigest {
    private int bufferPos = 0;
    private int keyLength = 0;
    private int digestLength;
    private int fanout;
    private int depth;
    private int nodeOffset = 0;
    private long innerHashLength;
    private Blake2sDigest[] S = new Blake2sDigest[8];
    private Blake2sDigest root;
    private byte[] buffer = null;
    private byte[] salt = null;
    private byte[] param = null;
    private byte[] key = null;
    private final int BLAKE2S_BLOCKBYTES = 64;
    private final int BLAKE2S_KEYBYTES = 32;
    private final int BLAKE2S_OUTBYTES = 32;
    private final int PARALLELISM_DEGREE = 8;
    private final byte[] singleByte = new byte[1];

    public Blake2spDigest(byte[] key) {
        this.param = new byte[32];
        this.buffer = new byte[512];
        this.init(key);
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2sp";
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public void update(byte in) {
        this.singleByte[0] = in;
        this.update(this.singleByte, 0, 1);
    }

    @Override
    public void update(byte[] message, int offset, int len) {
        int i;
        int left = this.bufferPos;
        int remainingLength = 512 - left;
        if (left != 0 && len >= remainingLength) {
            System.arraycopy(message, offset, this.buffer, left, remainingLength);
            i = 0;
            while (i < 8) {
                this.S[i].update(this.buffer, i * 64, 64);
                ++i;
            }
            offset += remainingLength;
            len -= remainingLength;
            left = 0;
        }
        i = 0;
        while (i < 8) {
            int inlen = len;
            int inOffset = offset;
            inOffset += i * 64;
            while (inlen >= 512) {
                this.S[i].update(message, inOffset, 64);
                inOffset += 512;
                inlen -= 512;
            }
            ++i;
        }
        offset += len - len % 512;
        if ((len %= 512) > 0) {
            System.arraycopy(message, offset, this.buffer, left, len);
        }
        this.bufferPos = left + len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[][] hash = new byte[8][32];
        int remainingLength = 0;
        int i = 0;
        while (i < 8) {
            if (this.bufferPos > i * 64) {
                remainingLength = this.bufferPos - i * 64;
                if (remainingLength > 64) {
                    remainingLength = 64;
                }
                this.S[i].update(this.buffer, i * 64, remainingLength);
            }
            this.S[i].doFinal(hash[i], 0);
            ++i;
        }
        i = 0;
        while (i < 8) {
            this.root.update(hash[i], 0, 32);
            ++i;
        }
        int length = this.root.doFinal(out, outOff);
        this.reset();
        return length;
    }

    @Override
    public void reset() {
        this.bufferPos = 0;
        this.digestLength = 32;
        this.root.reset();
        int i = 0;
        while (i < 8) {
            this.S[i].reset();
            ++i;
        }
        this.root.setAsLastNode();
        this.S[7].setAsLastNode();
        if (this.key != null) {
            byte[] block = new byte[64];
            System.arraycopy(this.key, 0, block, 0, this.keyLength);
            int i2 = 0;
            while (i2 < 8) {
                this.S[i2].update(block, 0, 64);
                ++i2;
            }
        }
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    private void init(byte[] key) {
        if (key != null && key.length > 0) {
            this.keyLength = key.length;
            if (this.keyLength > 32) {
                throw new IllegalArgumentException("Keys > 32 bytes are not supported");
            }
            this.key = Arrays.clone(key);
        }
        this.bufferPos = 0;
        this.digestLength = 32;
        this.fanout = 8;
        this.depth = 2;
        this.innerHashLength = 32L;
        this.param[0] = (byte)this.digestLength;
        this.param[1] = (byte)this.keyLength;
        this.param[2] = (byte)this.fanout;
        this.param[3] = (byte)this.depth;
        Pack.intToLittleEndian(0, this.param, 8);
        this.param[14] = 1;
        this.param[15] = (byte)this.innerHashLength;
        this.root = new Blake2sDigest(null, this.param);
        Pack.intToLittleEndian(this.nodeOffset, this.param, 8);
        this.param[14] = 0;
        int i = 0;
        while (i < 8) {
            Pack.intToLittleEndian(i, this.param, 8);
            this.S[i] = new Blake2sDigest(null, this.param);
            ++i;
        }
        this.root.setAsLastNode();
        this.S[7].setAsLastNode();
        if (key != null && this.keyLength > 0) {
            byte[] block = new byte[64];
            System.arraycopy(key, 0, block, 0, this.keyLength);
            int i2 = 0;
            while (i2 < 8) {
                this.S[i2].update(block, 0, 64);
                ++i2;
            }
        }
    }
}

