/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

abstract class AEADBaseEngine
implements AEADCipher {
    protected boolean forEncryption;
    protected String algorithmName;
    protected int KEY_SIZE;
    protected int IV_SIZE;
    protected int MAC_SIZE;
    protected byte[] initialAssociatedText;
    protected byte[] mac;

    AEADBaseEngine() {
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getKeyBytesSize() {
        return this.KEY_SIZE;
    }

    public int getIVBytesSize() {
        return this.IV_SIZE;
    }

    @Override
    public byte[] getMac() {
        return this.mac;
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{in}, 0, 1, out, outOff);
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        byte[] npub;
        KeyParameter key;
        this.forEncryption = forEncryption;
        if (params instanceof AEADParameters) {
            AEADParameters aeadParameters = (AEADParameters)params;
            key = aeadParameters.getKey();
            npub = aeadParameters.getNonce();
            this.initialAssociatedText = aeadParameters.getAssociatedText();
            int macSizeBits = aeadParameters.getMacSize();
            if (macSizeBits != this.MAC_SIZE * 8) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + macSizeBits);
            }
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV withIV = (ParametersWithIV)params;
            key = (KeyParameter)withIV.getParameters();
            npub = withIV.getIV();
            this.initialAssociatedText = null;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to " + this.algorithmName);
        }
        if (key == null) {
            throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " Init parameters must include a key");
        }
        if (npub == null || npub.length != this.IV_SIZE) {
            throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " requires exactly " + this.IV_SIZE + " bytes of IV");
        }
        byte[] k = key.getKey();
        if (k.length != this.KEY_SIZE) {
            throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " key must be " + this.KEY_SIZE + " bytes long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.init(k, npub);
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    protected abstract void init(byte[] var1, byte[] var2);

    protected void reset(boolean clearMac) {
        if (clearMac) {
            this.mac = null;
        }
    }
}

