/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.engines.AsconBaseEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class AsconAEAD128
extends AsconBaseEngine {
    public AsconAEAD128() {
        this.KEY_SIZE = 16;
        this.IV_SIZE = 16;
        this.MAC_SIZE = 16;
        this.ASCON_AEAD_RATE = 16;
        this.ASCON_IV = 17594342703105L;
        this.algorithmName = "Ascon-AEAD128";
        this.nr = 8;
        this.m_bufferSizeDecrypt = this.ASCON_AEAD_RATE + this.MAC_SIZE;
        this.m_buf = new byte[this.m_bufferSizeDecrypt];
        this.dsep = Long.MIN_VALUE;
    }

    @Override
    protected long pad(int i) {
        return 1L << (i << 3);
    }

    @Override
    protected long loadBytes(byte[] in, int inOff) {
        return Pack.littleEndianToLong(in, inOff);
    }

    @Override
    protected void setBytes(long n, byte[] bs, int off) {
        Pack.longToLittleEndian(n, bs, off);
    }

    @Override
    protected void ascon_aeadinit() {
        this.x0 = this.ASCON_IV;
        this.x1 = this.K0;
        this.x2 = this.K1;
        this.x3 = this.N0;
        this.x4 = this.N1;
        this.p(12);
        this.x3 ^= this.K0;
        this.x4 ^= this.K1;
    }

    @Override
    protected void processFinalAadBlock() {
        Arrays.fill(this.m_buf, this.m_bufPos, this.m_buf.length, (byte)0);
        if (this.m_bufPos >= 8) {
            this.x0 ^= Pack.littleEndianToLong(this.m_buf, 0);
            this.x1 ^= Pack.littleEndianToLong(this.m_buf, 8) ^ this.pad(this.m_bufPos);
        } else {
            this.x0 ^= Pack.littleEndianToLong(this.m_buf, 0) ^ this.pad(this.m_bufPos);
        }
    }

    @Override
    protected void processFinalDecrypt(byte[] input, int inLen, byte[] output, int outOff) {
        if (inLen >= 8) {
            long c0 = Pack.littleEndianToLong(input, 0);
            long c1 = Pack.littleEndianToLong(input, 8, inLen -= 8);
            Pack.longToLittleEndian(this.x0 ^ c0, output, outOff);
            Pack.longToLittleEndian(this.x1 ^ c1, output, outOff + 8, inLen);
            this.x0 = c0;
            this.x1 &= -(1L << (inLen << 3));
            this.x1 |= c1;
            this.x1 ^= this.pad(inLen);
        } else {
            if (inLen != 0) {
                long c0 = Pack.littleEndianToLong(input, 0, inLen);
                Pack.longToLittleEndian(this.x0 ^ c0, output, outOff, inLen);
                this.x0 &= -(1L << (inLen << 3));
                this.x0 |= c0;
            }
            this.x0 ^= this.pad(inLen);
        }
        this.finishData(AsconBaseEngine.State.DecFinal);
    }

    @Override
    protected void processFinalEncrypt(byte[] input, int inLen, byte[] output, int outOff) {
        if (inLen >= 8) {
            this.x0 ^= Pack.littleEndianToLong(input, 0);
            this.x1 ^= Pack.littleEndianToLong(input, 8, inLen -= 8);
            Pack.longToLittleEndian(this.x0, output, outOff);
            Pack.longToLittleEndian(this.x1, output, outOff + 8);
            this.x1 ^= this.pad(inLen);
        } else {
            if (inLen != 0) {
                this.x0 ^= Pack.littleEndianToLong(input, 0, inLen);
                Pack.longToLittleEndian(this.x0, output, outOff, inLen);
            }
            this.x0 ^= this.pad(inLen);
        }
        this.finishData(AsconBaseEngine.State.EncFinal);
    }

    private void finishData(AsconBaseEngine.State nextState) {
        this.x2 ^= this.K0;
        this.x3 ^= this.K1;
        this.p(12);
        this.x3 ^= this.K0;
        this.x4 ^= this.K1;
        this.m_state = nextState;
    }

    @Override
    protected void init(byte[] key, byte[] iv) throws IllegalArgumentException {
        this.K0 = Pack.littleEndianToLong(key, 0);
        this.K1 = Pack.littleEndianToLong(key, 8);
        this.N0 = Pack.littleEndianToLong(iv, 0);
        this.N1 = Pack.littleEndianToLong(iv, 8);
        this.m_state = this.forEncryption ? AsconBaseEngine.State.EncInit : AsconBaseEngine.State.DecInit;
        this.reset(true);
    }

    @Override
    public String getAlgorithmVersion() {
        return "v1.3";
    }
}

