/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Longs;

abstract class AsconBaseEngine
extends AEADBaseEngine {
    protected State m_state = State.Uninitialized;
    protected int nr;
    protected int ASCON_AEAD_RATE;
    protected long K0;
    protected long K1;
    protected long N0;
    protected long N1;
    protected long ASCON_IV;
    protected long x0;
    protected long x1;
    protected long x2;
    protected long x3;
    protected long x4;
    protected int m_bufferSizeDecrypt;
    protected byte[] m_buf;
    protected int m_bufPos = 0;
    protected long dsep;

    AsconBaseEngine() {
    }

    protected abstract long pad(int var1);

    protected abstract long loadBytes(byte[] var1, int var2);

    protected abstract void setBytes(long var1, byte[] var3, int var4);

    private void round(long C) {
        long t0 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ C ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ C);
        long t1 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ C ^ (this.x1 ^ this.x2 ^ C) & (this.x1 ^ this.x3);
        long t2 = this.x1 ^ this.x2 ^ this.x4 ^ C ^ this.x3 & this.x4;
        long t3 = this.x0 ^ this.x1 ^ this.x2 ^ C ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
        long t4 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
        this.x0 = t0 ^ Longs.rotateRight(t0, 19) ^ Longs.rotateRight(t0, 28);
        this.x1 = t1 ^ Longs.rotateRight(t1, 39) ^ Longs.rotateRight(t1, 61);
        this.x2 = t2 ^ Longs.rotateRight(t2, 1) ^ Longs.rotateRight(t2, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.x3 = t3 ^ Longs.rotateRight(t3, 10) ^ Longs.rotateRight(t3, 17);
        this.x4 = t4 ^ Longs.rotateRight(t4, 7) ^ Longs.rotateRight(t4, 41);
    }

    protected void p(int nr) {
        if (nr == 12) {
            this.round(240L);
            this.round(225L);
            this.round(210L);
            this.round(195L);
        }
        if (nr >= 8) {
            this.round(180L);
            this.round(165L);
        }
        this.round(150L);
        this.round(135L);
        this.round(120L);
        this.round(105L);
        this.round(90L);
        this.round(75L);
    }

    protected abstract void ascon_aeadinit();

    protected void checkAAD() {
        switch (this.m_state) {
            case DecInit: {
                this.m_state = State.DecAad;
                break;
            }
            case EncInit: {
                this.m_state = State.EncAad;
                break;
            }
            case EncAad: 
            case DecAad: {
                break;
            }
            case EncFinal: {
                throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " needs to be initialized");
            }
        }
    }

    protected boolean checkData() {
        switch (this.m_state) {
            case DecInit: 
            case DecAad: {
                this.finishAAD(State.DecData);
                return false;
            }
            case EncInit: 
            case EncAad: {
                this.finishAAD(State.EncData);
                return true;
            }
            case DecData: {
                return false;
            }
            case EncData: {
                return true;
            }
            case EncFinal: {
                throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " needs to be initialized");
    }

    private void finishAAD(State nextState) {
        switch (this.m_state) {
            case EncAad: 
            case DecAad: {
                this.processFinalAadBlock();
                this.p(this.nr);
                break;
            }
        }
        this.x4 ^= this.dsep;
        this.m_bufPos = 0;
        this.m_state = nextState;
    }

    protected abstract void processFinalAadBlock();

    protected abstract void processFinalDecrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void processFinalEncrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected void processBufferAAD(byte[] buffer, int inOff) {
        this.x0 ^= this.loadBytes(buffer, inOff);
        if (this.ASCON_AEAD_RATE == 16) {
            this.x1 ^= this.loadBytes(buffer, 8 + inOff);
        }
        this.p(this.nr);
    }

    protected void processBufferDecrypt(byte[] buffer, int bufOff, byte[] output, int outOff) {
        if (outOff + this.ASCON_AEAD_RATE > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
        long t0 = this.loadBytes(buffer, bufOff);
        this.setBytes(this.x0 ^ t0, output, outOff);
        this.x0 = t0;
        if (this.ASCON_AEAD_RATE == 16) {
            long t1 = this.loadBytes(buffer, bufOff + 8);
            this.setBytes(this.x1 ^ t1, output, outOff + 8);
            this.x1 = t1;
        }
        this.p(this.nr);
    }

    protected void processBufferEncrypt(byte[] buffer, int bufOff, byte[] output, int outOff) {
        if (outOff + this.ASCON_AEAD_RATE > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.x0 ^= this.loadBytes(buffer, bufOff);
        this.setBytes(this.x0, output, outOff);
        if (this.ASCON_AEAD_RATE == 16) {
            this.x1 ^= this.loadBytes(buffer, bufOff + 8);
            this.setBytes(this.x1, output, outOff + 8);
        }
        this.p(this.nr);
    }

    @Override
    public void processAADByte(byte in) {
        this.checkAAD();
        this.m_buf[this.m_bufPos] = in;
        if (++this.m_bufPos == this.ASCON_AEAD_RATE) {
            this.processBufferAAD(this.m_buf, 0);
            this.m_bufPos = 0;
        }
    }

    @Override
    public void processAADBytes(byte[] inBytes, int inOff, int len) {
        if (inOff + len > inBytes.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (len <= 0) {
            return;
        }
        this.checkAAD();
        if (this.m_bufPos > 0) {
            int available = this.ASCON_AEAD_RATE - this.m_bufPos;
            if (len < available) {
                System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                this.m_bufPos += len;
                return;
            }
            System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, available);
            inOff += available;
            len -= available;
            this.processBufferAAD(this.m_buf, 0);
        }
        while (len >= this.ASCON_AEAD_RATE) {
            this.processBufferAAD(inBytes, inOff);
            inOff += this.ASCON_AEAD_RATE;
            len -= this.ASCON_AEAD_RATE;
        }
        System.arraycopy(inBytes, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int processBytes(byte[] inBytes, int inOff, int len, byte[] outBytes, int outOff) throws DataLengthException {
        block7: {
            block6: {
                if (inOff + len > inBytes.length) {
                    throw new DataLengthException("input buffer too short");
                }
                forEncryption = this.checkData();
                resultLength = 0;
                if (!forEncryption) break block6;
                if (this.m_bufPos > 0) {
                    available = this.ASCON_AEAD_RATE - this.m_bufPos;
                    if (len < available) {
                        System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                        this.m_bufPos += len;
                        return 0;
                    }
                    System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, available);
                    inOff += available;
                    len -= available;
                    this.processBufferEncrypt(this.m_buf, 0, outBytes, outOff);
                    resultLength = this.ASCON_AEAD_RATE;
                }
                while (len >= this.ASCON_AEAD_RATE) {
                    this.processBufferEncrypt(inBytes, inOff, outBytes, outOff + resultLength);
                    inOff += this.ASCON_AEAD_RATE;
                    len -= this.ASCON_AEAD_RATE;
                    resultLength += this.ASCON_AEAD_RATE;
                }
                break block7;
            }
            available = this.m_bufferSizeDecrypt - this.m_bufPos;
            if (len >= available) ** GOTO lbl38
            System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
            this.m_bufPos += len;
            return 0;
lbl-1000:
            // 1 sources

            {
                this.processBufferDecrypt(this.m_buf, 0, outBytes, outOff + resultLength);
                this.m_bufPos -= this.ASCON_AEAD_RATE;
                System.arraycopy(this.m_buf, this.ASCON_AEAD_RATE, this.m_buf, 0, this.m_bufPos);
                resultLength += this.ASCON_AEAD_RATE;
                if (len >= (available += this.ASCON_AEAD_RATE)) continue;
                System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                this.m_bufPos += len;
                return resultLength;
lbl38:
                // 2 sources

                ** while (this.m_bufPos >= this.ASCON_AEAD_RATE)
            }
lbl39:
            // 1 sources

            available = this.ASCON_AEAD_RATE - this.m_bufPos;
            System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, available);
            inOff += available;
            len -= available;
            this.processBufferDecrypt(this.m_buf, 0, outBytes, outOff + resultLength);
            resultLength += this.ASCON_AEAD_RATE;
            while (len >= this.m_bufferSizeDecrypt) {
                this.processBufferDecrypt(inBytes, inOff, outBytes, outOff + resultLength);
                inOff += this.ASCON_AEAD_RATE;
                len -= this.ASCON_AEAD_RATE;
                resultLength += this.ASCON_AEAD_RATE;
            }
        }
        System.arraycopy(inBytes, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
        return resultLength;
    }

    @Override
    public int doFinal(byte[] outBytes, int outOff) throws IllegalStateException, InvalidCipherTextException, DataLengthException {
        int resultLength;
        boolean forEncryption = this.checkData();
        if (forEncryption) {
            resultLength = this.m_bufPos + this.MAC_SIZE;
            if (outOff + resultLength > outBytes.length) {
                throw new OutputLengthException("output buffer too short");
            }
            this.processFinalEncrypt(this.m_buf, this.m_bufPos, outBytes, outOff);
            this.mac = new byte[this.MAC_SIZE];
            this.setBytes(this.x3, this.mac, 0);
            this.setBytes(this.x4, this.mac, 8);
            System.arraycopy(this.mac, 0, outBytes, outOff + this.m_bufPos, this.MAC_SIZE);
            this.reset(false);
        } else {
            if (this.m_bufPos < this.MAC_SIZE) {
                throw new InvalidCipherTextException("data too short");
            }
            this.m_bufPos -= this.MAC_SIZE;
            resultLength = this.m_bufPos;
            if (outOff + resultLength > outBytes.length) {
                throw new OutputLengthException("output buffer too short");
            }
            this.processFinalDecrypt(this.m_buf, this.m_bufPos, outBytes, outOff);
            this.x3 ^= this.loadBytes(this.m_buf, this.m_bufPos);
            this.x4 ^= this.loadBytes(this.m_buf, this.m_bufPos + 8);
            if ((this.x3 | this.x4) != 0L) {
                throw new InvalidCipherTextException("mac check in " + this.getAlgorithmName() + " failed");
            }
            this.reset(true);
        }
        return resultLength;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int total = Math.max(0, len);
        switch (this.m_state) {
            case DecInit: 
            case DecAad: {
                total = Math.max(0, total - this.MAC_SIZE);
                break;
            }
            case DecData: 
            case DecFinal: {
                total = Math.max(0, total + this.m_bufPos - this.MAC_SIZE);
                break;
            }
            case EncData: 
            case EncFinal: {
                total += this.m_bufPos;
                break;
            }
        }
        return total - total % this.ASCON_AEAD_RATE;
    }

    @Override
    public int getOutputSize(int len) {
        int total = Math.max(0, len);
        switch (this.m_state) {
            case DecInit: 
            case DecAad: {
                return Math.max(0, total - this.MAC_SIZE);
            }
            case DecData: 
            case DecFinal: {
                return Math.max(0, total + this.m_bufPos - this.MAC_SIZE);
            }
            case EncData: 
            case EncFinal: {
                return total + this.m_bufPos + this.MAC_SIZE;
            }
        }
        return total + this.MAC_SIZE;
    }

    @Override
    protected void reset(boolean clearMac) {
        Arrays.clear(this.m_buf);
        this.m_bufPos = 0;
        switch (this.m_state) {
            case EncInit: 
            case DecInit: {
                break;
            }
            case DecAad: 
            case DecData: 
            case DecFinal: {
                this.m_state = State.DecInit;
                break;
            }
            case EncAad: 
            case EncData: 
            case EncFinal: {
                this.m_state = State.EncFinal;
                return;
            }
            default: {
                throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " needs to be initialized");
            }
        }
        this.ascon_aeadinit();
        super.reset(clearMac);
    }

    public abstract String getAlgorithmVersion();

    protected static enum State {
        Uninitialized,
        EncInit,
        EncAad,
        EncData,
        EncFinal,
        DecInit,
        DecAad,
        DecData,
        DecFinal;

    }
}

