/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.engines.AEADBaseEngine;

public class ElephantEngine
extends AEADBaseEngine {
    private final ElephantParameters parameters;
    private final int BLOCK_SIZE;
    private int nBits;
    private int nSBox;
    private final int nRounds;
    private byte lfsrIV;
    private byte[] npub;
    private byte[] expanded_key;
    private boolean initialised;
    private int nb_its;
    private byte[] ad;
    private int adOff;
    private int adlen;
    private final byte[] tag_buffer;
    private byte[] previous_mask;
    private byte[] current_mask;
    private byte[] next_mask;
    private final byte[] buffer;
    private final byte[] previous_outputMessage;
    private State m_state = State.Uninitialized;
    private final ByteArrayOutputStream aadData = new ByteArrayOutputStream();
    private int inputOff;
    private byte[] inputMessage;
    private int messageLen;
    private final byte[] sBoxLayer;
    private final byte[] KeccakRoundConstants;
    private final int[] KeccakRhoOffsets;

    public ElephantEngine(ElephantParameters parameters) {
        byte[] byArray = new byte[256];
        byArray[0] = -18;
        byArray[1] = -19;
        byArray[2] = -21;
        byArray[3] = -32;
        byArray[4] = -30;
        byArray[5] = -31;
        byArray[6] = -28;
        byArray[7] = -17;
        byArray[8] = -25;
        byArray[9] = -22;
        byArray[10] = -24;
        byArray[11] = -27;
        byArray[12] = -23;
        byArray[13] = -20;
        byArray[14] = -29;
        byArray[15] = -26;
        byArray[16] = -34;
        byArray[17] = -35;
        byArray[18] = -37;
        byArray[19] = -48;
        byArray[20] = -46;
        byArray[21] = -47;
        byArray[22] = -44;
        byArray[23] = -33;
        byArray[24] = -41;
        byArray[25] = -38;
        byArray[26] = -40;
        byArray[27] = -43;
        byArray[28] = -39;
        byArray[29] = -36;
        byArray[30] = -45;
        byArray[31] = -42;
        byArray[32] = -66;
        byArray[33] = -67;
        byArray[34] = -69;
        byArray[35] = -80;
        byArray[36] = -78;
        byArray[37] = -79;
        byArray[38] = -76;
        byArray[39] = -65;
        byArray[40] = -73;
        byArray[41] = -70;
        byArray[42] = -72;
        byArray[43] = -75;
        byArray[44] = -71;
        byArray[45] = -68;
        byArray[46] = -77;
        byArray[47] = -74;
        byArray[48] = 14;
        byArray[49] = 13;
        byArray[50] = 11;
        byArray[52] = 2;
        byArray[53] = 1;
        byArray[54] = 4;
        byArray[55] = 15;
        byArray[56] = 7;
        byArray[57] = 10;
        byArray[58] = 8;
        byArray[59] = 5;
        byArray[60] = 9;
        byArray[61] = 12;
        byArray[62] = 3;
        byArray[63] = 6;
        byArray[64] = 46;
        byArray[65] = 45;
        byArray[66] = 43;
        byArray[67] = 32;
        byArray[68] = 34;
        byArray[69] = 33;
        byArray[70] = 36;
        byArray[71] = 47;
        byArray[72] = 39;
        byArray[73] = 42;
        byArray[74] = 40;
        byArray[75] = 37;
        byArray[76] = 41;
        byArray[77] = 44;
        byArray[78] = 35;
        byArray[79] = 38;
        byArray[80] = 30;
        byArray[81] = 29;
        byArray[82] = 27;
        byArray[83] = 16;
        byArray[84] = 18;
        byArray[85] = 17;
        byArray[86] = 20;
        byArray[87] = 31;
        byArray[88] = 23;
        byArray[89] = 26;
        byArray[90] = 24;
        byArray[91] = 21;
        byArray[92] = 25;
        byArray[93] = 28;
        byArray[94] = 19;
        byArray[95] = 22;
        byArray[96] = 78;
        byArray[97] = 77;
        byArray[98] = 75;
        byArray[99] = 64;
        byArray[100] = 66;
        byArray[101] = 65;
        byArray[102] = 68;
        byArray[103] = 79;
        byArray[104] = 71;
        byArray[105] = 74;
        byArray[106] = 72;
        byArray[107] = 69;
        byArray[108] = 73;
        byArray[109] = 76;
        byArray[110] = 67;
        byArray[111] = 70;
        byArray[112] = -2;
        byArray[113] = -3;
        byArray[114] = -5;
        byArray[115] = -16;
        byArray[116] = -14;
        byArray[117] = -15;
        byArray[118] = -12;
        byArray[119] = -1;
        byArray[120] = -9;
        byArray[121] = -6;
        byArray[122] = -8;
        byArray[123] = -11;
        byArray[124] = -7;
        byArray[125] = -4;
        byArray[126] = -13;
        byArray[127] = -10;
        byArray[128] = 126;
        byArray[129] = 125;
        byArray[130] = 123;
        byArray[131] = 112;
        byArray[132] = 114;
        byArray[133] = 113;
        byArray[134] = 116;
        byArray[135] = 127;
        byArray[136] = 119;
        byArray[137] = 122;
        byArray[138] = 120;
        byArray[139] = 117;
        byArray[140] = 121;
        byArray[141] = 124;
        byArray[142] = 115;
        byArray[143] = 118;
        byArray[144] = -82;
        byArray[145] = -83;
        byArray[146] = -85;
        byArray[147] = -96;
        byArray[148] = -94;
        byArray[149] = -95;
        byArray[150] = -92;
        byArray[151] = -81;
        byArray[152] = -89;
        byArray[153] = -86;
        byArray[154] = -88;
        byArray[155] = -91;
        byArray[156] = -87;
        byArray[157] = -84;
        byArray[158] = -93;
        byArray[159] = -90;
        byArray[160] = -114;
        byArray[161] = -115;
        byArray[162] = -117;
        byArray[163] = -128;
        byArray[164] = -126;
        byArray[165] = -127;
        byArray[166] = -124;
        byArray[167] = -113;
        byArray[168] = -121;
        byArray[169] = -118;
        byArray[170] = -120;
        byArray[171] = -123;
        byArray[172] = -119;
        byArray[173] = -116;
        byArray[174] = -125;
        byArray[175] = -122;
        byArray[176] = 94;
        byArray[177] = 93;
        byArray[178] = 91;
        byArray[179] = 80;
        byArray[180] = 82;
        byArray[181] = 81;
        byArray[182] = 84;
        byArray[183] = 95;
        byArray[184] = 87;
        byArray[185] = 90;
        byArray[186] = 88;
        byArray[187] = 85;
        byArray[188] = 89;
        byArray[189] = 92;
        byArray[190] = 83;
        byArray[191] = 86;
        byArray[192] = -98;
        byArray[193] = -99;
        byArray[194] = -101;
        byArray[195] = -112;
        byArray[196] = -110;
        byArray[197] = -111;
        byArray[198] = -108;
        byArray[199] = -97;
        byArray[200] = -105;
        byArray[201] = -102;
        byArray[202] = -104;
        byArray[203] = -107;
        byArray[204] = -103;
        byArray[205] = -100;
        byArray[206] = -109;
        byArray[207] = -106;
        byArray[208] = -50;
        byArray[209] = -51;
        byArray[210] = -53;
        byArray[211] = -64;
        byArray[212] = -62;
        byArray[213] = -63;
        byArray[214] = -60;
        byArray[215] = -49;
        byArray[216] = -57;
        byArray[217] = -54;
        byArray[218] = -56;
        byArray[219] = -59;
        byArray[220] = -55;
        byArray[221] = -52;
        byArray[222] = -61;
        byArray[223] = -58;
        byArray[224] = 62;
        byArray[225] = 61;
        byArray[226] = 59;
        byArray[227] = 48;
        byArray[228] = 50;
        byArray[229] = 49;
        byArray[230] = 52;
        byArray[231] = 63;
        byArray[232] = 55;
        byArray[233] = 58;
        byArray[234] = 56;
        byArray[235] = 53;
        byArray[236] = 57;
        byArray[237] = 60;
        byArray[238] = 51;
        byArray[239] = 54;
        byArray[240] = 110;
        byArray[241] = 109;
        byArray[242] = 107;
        byArray[243] = 96;
        byArray[244] = 98;
        byArray[245] = 97;
        byArray[246] = 100;
        byArray[247] = 111;
        byArray[248] = 103;
        byArray[249] = 106;
        byArray[250] = 104;
        byArray[251] = 101;
        byArray[252] = 105;
        byArray[253] = 108;
        byArray[254] = 99;
        byArray[255] = 102;
        this.sBoxLayer = byArray;
        byte[] byArray2 = new byte[18];
        byArray2[0] = 1;
        byArray2[1] = -126;
        byArray2[2] = -118;
        byArray2[4] = -117;
        byArray2[5] = 1;
        byArray2[6] = -127;
        byArray2[7] = 9;
        byArray2[8] = -118;
        byArray2[9] = -120;
        byArray2[10] = 9;
        byArray2[11] = 10;
        byArray2[12] = -117;
        byArray2[13] = -117;
        byArray2[14] = -119;
        byArray2[15] = 3;
        byArray2[16] = 2;
        byArray2[17] = -128;
        this.KeccakRoundConstants = byArray2;
        int[] nArray = new int[25];
        nArray[1] = 1;
        nArray[2] = 6;
        nArray[3] = 4;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[7] = 6;
        nArray[8] = 7;
        nArray[9] = 4;
        nArray[10] = 3;
        nArray[11] = 2;
        nArray[12] = 3;
        nArray[13] = 1;
        nArray[14] = 7;
        nArray[15] = 1;
        nArray[16] = 5;
        nArray[17] = 7;
        nArray[18] = 5;
        nArray[20] = 2;
        nArray[21] = 2;
        nArray[22] = 5;
        nArray[24] = 6;
        this.KeccakRhoOffsets = nArray;
        this.KEY_SIZE = 16;
        this.IV_SIZE = 12;
        switch (parameters) {
            case elephant160: {
                this.BLOCK_SIZE = 20;
                this.nBits = 160;
                this.nSBox = 20;
                this.nRounds = 80;
                this.lfsrIV = (byte)117;
                this.MAC_SIZE = 8;
                this.algorithmName = "Elephant 160 AEAD";
                break;
            }
            case elephant176: {
                this.BLOCK_SIZE = 22;
                this.nBits = 176;
                this.nSBox = 22;
                this.nRounds = 90;
                this.lfsrIV = (byte)69;
                this.algorithmName = "Elephant 176 AEAD";
                this.MAC_SIZE = 8;
                break;
            }
            case elephant200: {
                this.BLOCK_SIZE = 25;
                this.nRounds = 18;
                this.algorithmName = "Elephant 200 AEAD";
                this.MAC_SIZE = 16;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter settings for Elephant");
            }
        }
        this.parameters = parameters;
        this.tag_buffer = new byte[this.BLOCK_SIZE];
        this.previous_mask = new byte[this.BLOCK_SIZE];
        this.current_mask = new byte[this.BLOCK_SIZE];
        this.next_mask = new byte[this.BLOCK_SIZE];
        this.buffer = new byte[this.BLOCK_SIZE];
        this.previous_outputMessage = new byte[this.BLOCK_SIZE];
        this.initialised = false;
        this.reset(false);
    }

    private void permutation(byte[] state) {
        switch (this.parameters) {
            case elephant160: 
            case elephant176: {
                byte IV = this.lfsrIV;
                byte[] tmp = new byte[this.nSBox];
                int i = 0;
                while (i < this.nRounds) {
                    state[0] = (byte)(state[0] ^ IV);
                    int n = this.nSBox - 1;
                    state[n] = (byte)(state[n] ^ (byte)((IV & 1) << 7 | (IV & 2) << 5 | (IV & 4) << 3 | (IV & 8) << 1 | (IV & 0x10) >>> 1 | (IV & 0x20) >>> 3 | (IV & 0x40) >>> 5 | (IV & 0x80) >>> 7));
                    IV = (byte)((IV << 1 | (0x40 & IV) >>> 6 ^ (0x20 & IV) >>> 5) & 0x7F);
                    int j = 0;
                    while (j < this.nSBox) {
                        state[j] = this.sBoxLayer[state[j] & 0xFF];
                        ++j;
                    }
                    Arrays.fill(tmp, (byte)0);
                    int j2 = 0;
                    while (j2 < this.nSBox) {
                        int k = 0;
                        while (k < 8) {
                            int PermutedBitNo = (j2 << 3) + k;
                            if (PermutedBitNo != this.nBits - 1) {
                                PermutedBitNo = (PermutedBitNo * this.nBits >> 2) % (this.nBits - 1);
                            }
                            int n2 = PermutedBitNo >>> 3;
                            tmp[n2] = (byte)(tmp[n2] ^ ((state[j2] & 0xFF) >>> k & 1) << (PermutedBitNo & 7));
                            ++k;
                        }
                        ++j2;
                    }
                    System.arraycopy(tmp, 0, state, 0, this.nSBox);
                    ++i;
                }
                break;
            }
            case elephant200: {
                int i = 0;
                while (i < this.nRounds) {
                    this.KeccakP200Round(state, i);
                    ++i;
                }
                break;
            }
        }
    }

    private byte rotl(byte b) {
        return (byte)((b & 0xFF) << 1 | (b & 0xFF) >>> 7);
    }

    private byte ROL8(byte a, int offset) {
        return (byte)(offset != 0 ? (a & 0xFF) << offset ^ (a & 0xFF) >>> 8 - offset : a);
    }

    private int index(int x, int y) {
        return x + y * 5;
    }

    private void KeccakP200Round(byte[] state, int indexRound) {
        int y;
        byte[] tempA = new byte[25];
        int x = 0;
        while (x < 5) {
            y = 0;
            while (y < 5) {
                int n = x;
                tempA[n] = (byte)(tempA[n] ^ state[this.index(x, y)]);
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < 5) {
            tempA[x + 5] = (byte)(this.ROL8(tempA[(x + 1) % 5], 1) ^ tempA[(x + 4) % 5]);
            ++x;
        }
        x = 0;
        while (x < 5) {
            y = 0;
            while (y < 5) {
                int n = this.index(x, y);
                state[n] = (byte)(state[n] ^ tempA[x + 5]);
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < 5) {
            y = 0;
            while (y < 5) {
                tempA[this.index((int)x, (int)y)] = this.ROL8(state[this.index(x, y)], this.KeccakRhoOffsets[this.index(x, y)]);
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < 5) {
            y = 0;
            while (y < 5) {
                state[this.index((int)y, (int)((2 * x + 3 * y) % 5))] = tempA[this.index(x, y)];
                ++y;
            }
            ++x;
        }
        y = 0;
        while (y < 5) {
            x = 0;
            while (x < 5) {
                tempA[x] = (byte)(state[this.index(x, y)] ^ ~state[this.index((x + 1) % 5, y)] & state[this.index((x + 2) % 5, y)]);
                ++x;
            }
            x = 0;
            while (x < 5) {
                state[this.index((int)x, (int)y)] = tempA[x];
                ++x;
            }
            ++y;
        }
        state[0] = (byte)(state[0] ^ this.KeccakRoundConstants[indexRound]);
    }

    private void lfsr_step(byte[] output, byte[] input) {
        switch (this.parameters) {
            case elephant160: {
                output[this.BLOCK_SIZE - 1] = (byte)(((input[0] & 0xFF) << 3 | (input[0] & 0xFF) >>> 5) ^ (input[3] & 0xFF) << 7 ^ (input[13] & 0xFF) >>> 7);
                break;
            }
            case elephant176: {
                output[this.BLOCK_SIZE - 1] = (byte)(this.rotl(input[0]) ^ (input[3] & 0xFF) << 7 ^ (input[19] & 0xFF) >>> 7);
                break;
            }
            case elephant200: {
                output[this.BLOCK_SIZE - 1] = (byte)(this.rotl(input[0]) ^ this.rotl(input[2]) ^ input[13] << 1);
            }
        }
        System.arraycopy(input, 1, output, 0, this.BLOCK_SIZE - 1);
    }

    private void xor_block(byte[] state, byte[] block, int bOff, int size) {
        int i = 0;
        while (i < size) {
            int n = i;
            state[n] = (byte)(state[n] ^ block[i + bOff]);
            ++i;
        }
    }

    @Override
    protected void init(byte[] k, byte[] iv) throws IllegalArgumentException {
        this.npub = iv;
        this.expanded_key = new byte[this.BLOCK_SIZE];
        System.arraycopy(k, 0, this.expanded_key, 0, this.KEY_SIZE);
        this.permutation(this.expanded_key);
        this.initialised = true;
        this.m_state = this.forEncryption ? State.EncInit : State.DecInit;
        this.inputMessage = new byte[this.BLOCK_SIZE * 2 + (this.forEncryption ? 0 : this.MAC_SIZE)];
        this.reset(false);
    }

    @Override
    public void processAADByte(byte input) {
        this.aadData.write(input);
    }

    @Override
    public void processAADBytes(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.aadData.write(input, inOff, len);
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (this.inputOff + len - (this.forEncryption ? 0 : this.MAC_SIZE) >= this.BLOCK_SIZE) {
            int mlen = this.inputOff + this.messageLen + len - (this.forEncryption ? 0 : this.MAC_SIZE);
            int adlen = this.processAADBytes();
            int nblocks_c = 1 + mlen / this.BLOCK_SIZE;
            int nblocks_m = mlen % this.BLOCK_SIZE != 0 ? nblocks_c : nblocks_c - 1;
            int nblocks_ad = 1 + (this.IV_SIZE + adlen) / this.BLOCK_SIZE;
            int nb_it = Math.max(nblocks_c + 1, nblocks_ad - 1);
            byte[] tempInput = new byte[Math.max(nblocks_c, 1) * this.BLOCK_SIZE];
            System.arraycopy(this.inputMessage, 0, tempInput, 0, this.inputOff);
            System.arraycopy(input, inOff, tempInput, this.inputOff, Math.min(len, tempInput.length - this.inputOff));
            int rv = this.processBytes(tempInput, output, outOff, nb_it, nblocks_m, nblocks_c, mlen, nblocks_ad, false);
            int copyLen = rv - this.inputOff;
            if (copyLen >= 0) {
                this.inputOff = this.inputOff + len - rv;
                System.arraycopy(input, inOff + copyLen, this.inputMessage, 0, this.inputOff);
            } else {
                System.arraycopy(this.inputMessage, this.inputOff + copyLen, this.inputMessage, 0, -copyLen);
                System.arraycopy(input, inOff, this.inputMessage, -copyLen, len);
                this.inputOff = len - copyLen;
            }
            this.messageLen += rv;
            return rv;
        }
        System.arraycopy(input, inOff, this.inputMessage, this.inputOff, len);
        this.inputOff += len;
        return 0;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        if (!this.initialised) {
            throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " needs call init function before doFinal");
        }
        int len = this.inputOff;
        if (this.forEncryption && len + outOff + this.MAC_SIZE > output.length || !this.forEncryption && len + outOff - this.MAC_SIZE > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        int mlen = len + this.messageLen - (this.forEncryption ? 0 : this.MAC_SIZE);
        int rv = mlen - this.messageLen;
        int adlen = this.processAADBytes();
        int nblocks_c = 1 + mlen / this.BLOCK_SIZE;
        int nblocks_m = mlen % this.BLOCK_SIZE != 0 ? nblocks_c : nblocks_c - 1;
        int nblocks_ad = 1 + (this.IV_SIZE + adlen) / this.BLOCK_SIZE;
        int nb_it = Math.max(nblocks_c + 1, nblocks_ad - 1);
        outOff += this.processBytes(this.inputMessage, output, outOff, nb_it, nblocks_m, nblocks_c, mlen, nblocks_ad, true);
        this.mac = new byte[this.MAC_SIZE];
        this.xor_block(this.tag_buffer, this.expanded_key, 0, this.BLOCK_SIZE);
        this.permutation(this.tag_buffer);
        this.xor_block(this.tag_buffer, this.expanded_key, 0, this.BLOCK_SIZE);
        if (this.forEncryption) {
            System.arraycopy(this.tag_buffer, 0, this.mac, 0, this.MAC_SIZE);
            System.arraycopy(this.mac, 0, output, outOff, this.mac.length);
            rv += this.MAC_SIZE;
        } else {
            this.inputOff -= this.MAC_SIZE;
            int i = 0;
            while (i < this.MAC_SIZE) {
                if (this.tag_buffer[i] != this.inputMessage[this.inputOff + i]) {
                    throw new IllegalArgumentException("Mac does not match");
                }
                ++i;
            }
        }
        this.reset(false);
        return rv;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        switch (this.m_state) {
            case Uninitialized: {
                throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " needs call init function before getUpdateOutputSize");
            }
            case EncFinal: 
            case DecFinal: {
                return 0;
            }
            case EncInit: 
            case EncAad: 
            case EncData: {
                int total = this.inputOff + len;
                return total - total % this.BLOCK_SIZE;
            }
            case DecInit: 
            case DecAad: 
            case DecData: {
                int total = Math.max(0, this.inputOff + len - this.MAC_SIZE);
                return total - total % this.BLOCK_SIZE;
            }
        }
        return Math.max(0, len + this.inputOff - this.MAC_SIZE);
    }

    @Override
    public int getOutputSize(int len) {
        switch (this.m_state) {
            case Uninitialized: {
                throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " needs call init function before getUpdateOutputSize");
            }
            case EncFinal: 
            case DecFinal: {
                return 0;
            }
            case EncInit: 
            case EncAad: 
            case EncData: {
                return len + this.inputOff + this.MAC_SIZE;
            }
        }
        return Math.max(0, len + this.inputOff - this.MAC_SIZE);
    }

    private int processAADBytes() {
        byte[] ad = this.aadData.toByteArray();
        switch (this.m_state) {
            case EncInit: 
            case DecInit: {
                this.processAADBytes(this.tag_buffer);
            }
        }
        return ad.length;
    }

    @Override
    protected void reset(boolean clearMac) {
        this.aadData.reset();
        Arrays.fill(this.tag_buffer, (byte)0);
        Arrays.fill(this.previous_outputMessage, (byte)0);
        this.inputOff = 0;
        this.nb_its = 0;
        this.adOff = -1;
        this.messageLen = 0;
        super.reset(clearMac);
    }

    public int getBlockSize() {
        return this.BLOCK_SIZE;
    }

    private void checkAad() {
        switch (this.m_state) {
            case DecData: {
                throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " cannot process AAD when the length of the plaintext to be processed exceeds the a block size");
            }
            case EncData: {
                throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " cannot process AAD when the length of the ciphertext to be processed exceeds the a block size");
            }
            case EncFinal: {
                throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " cannot be reused for encryption");
            }
        }
    }

    private void processAADBytes(byte[] output) {
        this.checkAad();
        if (this.adOff == -1) {
            this.adlen = this.aadData.size();
            this.ad = this.aadData.toByteArray();
            this.adOff = 0;
        }
        int len = 0;
        switch (this.m_state) {
            case DecInit: {
                System.arraycopy(this.expanded_key, 0, this.current_mask, 0, this.BLOCK_SIZE);
                System.arraycopy(this.npub, 0, output, 0, this.IV_SIZE);
                len += this.IV_SIZE;
                this.m_state = State.DecAad;
                break;
            }
            case EncInit: {
                System.arraycopy(this.expanded_key, 0, this.current_mask, 0, this.BLOCK_SIZE);
                System.arraycopy(this.npub, 0, output, 0, this.IV_SIZE);
                len += this.IV_SIZE;
                this.m_state = State.EncAad;
                break;
            }
            case EncAad: 
            case DecAad: {
                if (this.adOff != this.adlen) break;
                Arrays.fill(output, 0, this.BLOCK_SIZE, (byte)0);
                output[0] = 1;
                return;
            }
            case DecData: {
                throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " cannot process AAD when the length of the plaintext to be processed exceeds the a block size");
            }
            case EncData: {
                throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " cannot process AAD when the length of the ciphertext to be processed exceeds the a block size");
            }
            case EncFinal: {
                throw new IllegalArgumentException(String.valueOf(this.algorithmName) + " cannot be reused for encryption");
            }
        }
        int r_outlen = this.BLOCK_SIZE - len;
        int r_adlen = this.adlen - this.adOff;
        if (r_outlen <= r_adlen) {
            System.arraycopy(this.ad, this.adOff, output, len, r_outlen);
            this.adOff += r_outlen;
        } else {
            if (r_adlen > 0) {
                System.arraycopy(this.ad, this.adOff, output, len, r_adlen);
                this.adOff += r_adlen;
            }
            Arrays.fill(output, len + r_adlen, len + r_outlen, (byte)0);
            output[len + r_adlen] = 1;
            switch (this.m_state) {
                case DecAad: {
                    this.m_state = State.DecData;
                    break;
                }
                case EncAad: {
                    this.m_state = State.EncData;
                }
            }
        }
    }

    private int processBytes(byte[] m, byte[] output, int outOff, int nb_it, int nblocks_m, int nblocks_c, int mlen, int nblocks_ad, boolean isDofinal) {
        int rv = 0;
        byte[] outputMessage = new byte[this.BLOCK_SIZE];
        int i = this.nb_its;
        while (i < nb_it) {
            int r_size;
            int n = r_size = i == nblocks_m - 1 ? mlen - i * this.BLOCK_SIZE : this.BLOCK_SIZE;
            if (!isDofinal && (mlen <= i * this.BLOCK_SIZE || r_size % this.BLOCK_SIZE != 0)) break;
            this.lfsr_step(this.next_mask, this.current_mask);
            if (i < nblocks_m) {
                System.arraycopy(this.npub, 0, this.buffer, 0, this.IV_SIZE);
                Arrays.fill(this.buffer, this.IV_SIZE, this.BLOCK_SIZE, (byte)0);
                this.xor_block(this.buffer, this.current_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.permutation(this.buffer);
                this.xor_block(this.buffer, this.current_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.buffer, m, rv, r_size);
                System.arraycopy(this.buffer, 0, output, outOff, r_size);
                if (this.forEncryption) {
                    System.arraycopy(this.buffer, 0, outputMessage, 0, r_size);
                } else {
                    System.arraycopy(m, rv, outputMessage, 0, r_size);
                }
                outOff += r_size;
                rv += r_size;
            }
            if (i > 0 && i <= nblocks_c) {
                int block_offset = (i - 1) * this.BLOCK_SIZE;
                if (block_offset == mlen) {
                    Arrays.fill(this.buffer, 0, this.BLOCK_SIZE, (byte)0);
                    this.buffer[0] = 1;
                } else {
                    int r_clen = mlen - block_offset;
                    if (this.BLOCK_SIZE <= r_clen) {
                        System.arraycopy(this.previous_outputMessage, 0, this.buffer, 0, this.BLOCK_SIZE);
                    } else if (r_clen > 0) {
                        System.arraycopy(this.previous_outputMessage, 0, this.buffer, 0, r_clen);
                        Arrays.fill(this.buffer, r_clen, this.BLOCK_SIZE, (byte)0);
                        this.buffer[r_clen] = 1;
                    }
                }
                this.xor_block(this.buffer, this.previous_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.permutation(this.buffer);
                this.xor_block(this.buffer, this.previous_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.tag_buffer, this.buffer, 0, this.BLOCK_SIZE);
            }
            if (i + 1 < nblocks_ad) {
                this.processAADBytes(this.buffer);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.permutation(this.buffer);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.tag_buffer, this.buffer, 0, this.BLOCK_SIZE);
            }
            byte[] temp = this.previous_mask;
            this.previous_mask = this.current_mask;
            this.current_mask = this.next_mask;
            this.next_mask = temp;
            System.arraycopy(outputMessage, 0, this.previous_outputMessage, 0, this.BLOCK_SIZE);
            ++i;
        }
        this.nb_its = i;
        return rv;
    }

    public static enum ElephantParameters {
        elephant160,
        elephant176,
        elephant200;

    }

    private static enum State {
        Uninitialized,
        EncInit,
        EncAad,
        EncData,
        EncFinal,
        DecInit,
        DecAad,
        DecData,
        DecFinal;

    }
}

