/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public final class TwofishEngine
implements BlockCipher {
    private static final byte[][] P;
    private static final int P_00 = 1;
    private static final int P_01 = 0;
    private static final int P_02 = 0;
    private static final int P_03 = 1;
    private static final int P_04 = 1;
    private static final int P_10 = 0;
    private static final int P_11 = 0;
    private static final int P_12 = 1;
    private static final int P_13 = 1;
    private static final int P_14 = 0;
    private static final int P_20 = 1;
    private static final int P_21 = 1;
    private static final int P_22 = 0;
    private static final int P_23 = 0;
    private static final int P_24 = 0;
    private static final int P_30 = 0;
    private static final int P_31 = 1;
    private static final int P_32 = 1;
    private static final int P_33 = 0;
    private static final int P_34 = 1;
    private static final int GF256_FDBK = 361;
    private static final int GF256_FDBK_2 = 180;
    private static final int GF256_FDBK_4 = 90;
    private static final int RS_GF_FDBK = 333;
    private static final int ROUNDS = 16;
    private static final int MAX_ROUNDS = 16;
    private static final int BLOCK_SIZE = 16;
    private static final int MAX_KEY_BITS = 256;
    private static final int INPUT_WHITEN = 0;
    private static final int OUTPUT_WHITEN = 4;
    private static final int ROUND_SUBKEYS = 8;
    private static final int TOTAL_SUBKEYS = 40;
    private static final int SK_STEP = 0x2020202;
    private static final int SK_BUMP = 0x1010101;
    private static final int SK_ROTL = 9;
    private boolean encrypting = false;
    private int[] gMDS0 = new int[256];
    private int[] gMDS1 = new int[256];
    private int[] gMDS2 = new int[256];
    private int[] gMDS3 = new int[256];
    private int[] gSubKeys;
    private int[] gSBox;
    private int k64Cnt = 0;
    private byte[] workingKey = null;

    static {
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = new byte[256];
        byArray[0] = -87;
        byArray[1] = 103;
        byArray[2] = -77;
        byArray[3] = -24;
        byArray[4] = 4;
        byArray[5] = -3;
        byArray[6] = -93;
        byArray[7] = 118;
        byArray[8] = -102;
        byArray[9] = -110;
        byArray[10] = -128;
        byArray[11] = 120;
        byArray[12] = -28;
        byArray[13] = -35;
        byArray[14] = -47;
        byArray[15] = 56;
        byArray[16] = 13;
        byArray[17] = -58;
        byArray[18] = 53;
        byArray[19] = -104;
        byArray[20] = 24;
        byArray[21] = -9;
        byArray[22] = -20;
        byArray[23] = 108;
        byArray[24] = 67;
        byArray[25] = 117;
        byArray[26] = 55;
        byArray[27] = 38;
        byArray[28] = -6;
        byArray[29] = 19;
        byArray[30] = -108;
        byArray[31] = 72;
        byArray[32] = -14;
        byArray[33] = -48;
        byArray[34] = -117;
        byArray[35] = 48;
        byArray[36] = -124;
        byArray[37] = 84;
        byArray[38] = -33;
        byArray[39] = 35;
        byArray[40] = 25;
        byArray[41] = 91;
        byArray[42] = 61;
        byArray[43] = 89;
        byArray[44] = -13;
        byArray[45] = -82;
        byArray[46] = -94;
        byArray[47] = -126;
        byArray[48] = 99;
        byArray[49] = 1;
        byArray[50] = -125;
        byArray[51] = 46;
        byArray[52] = -39;
        byArray[53] = 81;
        byArray[54] = -101;
        byArray[55] = 124;
        byArray[56] = -90;
        byArray[57] = -21;
        byArray[58] = -91;
        byArray[59] = -66;
        byArray[60] = 22;
        byArray[61] = 12;
        byArray[62] = -29;
        byArray[63] = 97;
        byArray[64] = -64;
        byArray[65] = -116;
        byArray[66] = 58;
        byArray[67] = -11;
        byArray[68] = 115;
        byArray[69] = 44;
        byArray[70] = 37;
        byArray[71] = 11;
        byArray[72] = -69;
        byArray[73] = 78;
        byArray[74] = -119;
        byArray[75] = 107;
        byArray[76] = 83;
        byArray[77] = 106;
        byArray[78] = -76;
        byArray[79] = -15;
        byArray[80] = -31;
        byArray[81] = -26;
        byArray[82] = -67;
        byArray[83] = 69;
        byArray[84] = -30;
        byArray[85] = -12;
        byArray[86] = -74;
        byArray[87] = 102;
        byArray[88] = -52;
        byArray[89] = -107;
        byArray[90] = 3;
        byArray[91] = 86;
        byArray[92] = -44;
        byArray[93] = 28;
        byArray[94] = 30;
        byArray[95] = -41;
        byArray[96] = -5;
        byArray[97] = -61;
        byArray[98] = -114;
        byArray[99] = -75;
        byArray[100] = -23;
        byArray[101] = -49;
        byArray[102] = -65;
        byArray[103] = -70;
        byArray[104] = -22;
        byArray[105] = 119;
        byArray[106] = 57;
        byArray[107] = -81;
        byArray[108] = 51;
        byArray[109] = -55;
        byArray[110] = 98;
        byArray[111] = 113;
        byArray[112] = -127;
        byArray[113] = 121;
        byArray[114] = 9;
        byArray[115] = -83;
        byArray[116] = 36;
        byArray[117] = -51;
        byArray[118] = -7;
        byArray[119] = -40;
        byArray[120] = -27;
        byArray[121] = -59;
        byArray[122] = -71;
        byArray[123] = 77;
        byArray[124] = 68;
        byArray[125] = 8;
        byArray[126] = -122;
        byArray[127] = -25;
        byArray[128] = -95;
        byArray[129] = 29;
        byArray[130] = -86;
        byArray[131] = -19;
        byArray[132] = 6;
        byArray[133] = 112;
        byArray[134] = -78;
        byArray[135] = -46;
        byArray[136] = 65;
        byArray[137] = 123;
        byArray[138] = -96;
        byArray[139] = 17;
        byArray[140] = 49;
        byArray[141] = -62;
        byArray[142] = 39;
        byArray[143] = -112;
        byArray[144] = 32;
        byArray[145] = -10;
        byArray[146] = 96;
        byArray[147] = -1;
        byArray[148] = -106;
        byArray[149] = 92;
        byArray[150] = -79;
        byArray[151] = -85;
        byArray[152] = -98;
        byArray[153] = -100;
        byArray[154] = 82;
        byArray[155] = 27;
        byArray[156] = 95;
        byArray[157] = -109;
        byArray[158] = 10;
        byArray[159] = -17;
        byArray[160] = -111;
        byArray[161] = -123;
        byArray[162] = 73;
        byArray[163] = -18;
        byArray[164] = 45;
        byArray[165] = 79;
        byArray[166] = -113;
        byArray[167] = 59;
        byArray[168] = 71;
        byArray[169] = -121;
        byArray[170] = 109;
        byArray[171] = 70;
        byArray[172] = -42;
        byArray[173] = 62;
        byArray[174] = 105;
        byArray[175] = 100;
        byArray[176] = 42;
        byArray[177] = -50;
        byArray[178] = -53;
        byArray[179] = 47;
        byArray[180] = -4;
        byArray[181] = -105;
        byArray[182] = 5;
        byArray[183] = 122;
        byArray[184] = -84;
        byArray[185] = 127;
        byArray[186] = -43;
        byArray[187] = 26;
        byArray[188] = 75;
        byArray[189] = 14;
        byArray[190] = -89;
        byArray[191] = 90;
        byArray[192] = 40;
        byArray[193] = 20;
        byArray[194] = 63;
        byArray[195] = 41;
        byArray[196] = -120;
        byArray[197] = 60;
        byArray[198] = 76;
        byArray[199] = 2;
        byArray[200] = -72;
        byArray[201] = -38;
        byArray[202] = -80;
        byArray[203] = 23;
        byArray[204] = 85;
        byArray[205] = 31;
        byArray[206] = -118;
        byArray[207] = 125;
        byArray[208] = 87;
        byArray[209] = -57;
        byArray[210] = -115;
        byArray[211] = 116;
        byArray[212] = -73;
        byArray[213] = -60;
        byArray[214] = -97;
        byArray[215] = 114;
        byArray[216] = 126;
        byArray[217] = 21;
        byArray[218] = 34;
        byArray[219] = 18;
        byArray[220] = 88;
        byArray[221] = 7;
        byArray[222] = -103;
        byArray[223] = 52;
        byArray[224] = 110;
        byArray[225] = 80;
        byArray[226] = -34;
        byArray[227] = 104;
        byArray[228] = 101;
        byArray[229] = -68;
        byArray[230] = -37;
        byArray[231] = -8;
        byArray[232] = -56;
        byArray[233] = -88;
        byArray[234] = 43;
        byArray[235] = 64;
        byArray[236] = -36;
        byArray[237] = -2;
        byArray[238] = 50;
        byArray[239] = -92;
        byArray[240] = -54;
        byArray[241] = 16;
        byArray[242] = 33;
        byArray[243] = -16;
        byArray[244] = -45;
        byArray[245] = 93;
        byArray[246] = 15;
        byArray[248] = 111;
        byArray[249] = -99;
        byArray[250] = 54;
        byArray[251] = 66;
        byArray[252] = 74;
        byArray[253] = 94;
        byArray[254] = -63;
        byArray[255] = -32;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[0] = 117;
        byArray2[1] = -13;
        byArray2[2] = -58;
        byArray2[3] = -12;
        byArray2[4] = -37;
        byArray2[5] = 123;
        byArray2[6] = -5;
        byArray2[7] = -56;
        byArray2[8] = 74;
        byArray2[9] = -45;
        byArray2[10] = -26;
        byArray2[11] = 107;
        byArray2[12] = 69;
        byArray2[13] = 125;
        byArray2[14] = -24;
        byArray2[15] = 75;
        byArray2[16] = -42;
        byArray2[17] = 50;
        byArray2[18] = -40;
        byArray2[19] = -3;
        byArray2[20] = 55;
        byArray2[21] = 113;
        byArray2[22] = -15;
        byArray2[23] = -31;
        byArray2[24] = 48;
        byArray2[25] = 15;
        byArray2[26] = -8;
        byArray2[27] = 27;
        byArray2[28] = -121;
        byArray2[29] = -6;
        byArray2[30] = 6;
        byArray2[31] = 63;
        byArray2[32] = 94;
        byArray2[33] = -70;
        byArray2[34] = -82;
        byArray2[35] = 91;
        byArray2[36] = -118;
        byArray2[38] = -68;
        byArray2[39] = -99;
        byArray2[40] = 109;
        byArray2[41] = -63;
        byArray2[42] = -79;
        byArray2[43] = 14;
        byArray2[44] = -128;
        byArray2[45] = 93;
        byArray2[46] = -46;
        byArray2[47] = -43;
        byArray2[48] = -96;
        byArray2[49] = -124;
        byArray2[50] = 7;
        byArray2[51] = 20;
        byArray2[52] = -75;
        byArray2[53] = -112;
        byArray2[54] = 44;
        byArray2[55] = -93;
        byArray2[56] = -78;
        byArray2[57] = 115;
        byArray2[58] = 76;
        byArray2[59] = 84;
        byArray2[60] = -110;
        byArray2[61] = 116;
        byArray2[62] = 54;
        byArray2[63] = 81;
        byArray2[64] = 56;
        byArray2[65] = -80;
        byArray2[66] = -67;
        byArray2[67] = 90;
        byArray2[68] = -4;
        byArray2[69] = 96;
        byArray2[70] = 98;
        byArray2[71] = -106;
        byArray2[72] = 108;
        byArray2[73] = 66;
        byArray2[74] = -9;
        byArray2[75] = 16;
        byArray2[76] = 124;
        byArray2[77] = 40;
        byArray2[78] = 39;
        byArray2[79] = -116;
        byArray2[80] = 19;
        byArray2[81] = -107;
        byArray2[82] = -100;
        byArray2[83] = -57;
        byArray2[84] = 36;
        byArray2[85] = 70;
        byArray2[86] = 59;
        byArray2[87] = 112;
        byArray2[88] = -54;
        byArray2[89] = -29;
        byArray2[90] = -123;
        byArray2[91] = -53;
        byArray2[92] = 17;
        byArray2[93] = -48;
        byArray2[94] = -109;
        byArray2[95] = -72;
        byArray2[96] = -90;
        byArray2[97] = -125;
        byArray2[98] = 32;
        byArray2[99] = -1;
        byArray2[100] = -97;
        byArray2[101] = 119;
        byArray2[102] = -61;
        byArray2[103] = -52;
        byArray2[104] = 3;
        byArray2[105] = 111;
        byArray2[106] = 8;
        byArray2[107] = -65;
        byArray2[108] = 64;
        byArray2[109] = -25;
        byArray2[110] = 43;
        byArray2[111] = -30;
        byArray2[112] = 121;
        byArray2[113] = 12;
        byArray2[114] = -86;
        byArray2[115] = -126;
        byArray2[116] = 65;
        byArray2[117] = 58;
        byArray2[118] = -22;
        byArray2[119] = -71;
        byArray2[120] = -28;
        byArray2[121] = -102;
        byArray2[122] = -92;
        byArray2[123] = -105;
        byArray2[124] = 126;
        byArray2[125] = -38;
        byArray2[126] = 122;
        byArray2[127] = 23;
        byArray2[128] = 102;
        byArray2[129] = -108;
        byArray2[130] = -95;
        byArray2[131] = 29;
        byArray2[132] = 61;
        byArray2[133] = -16;
        byArray2[134] = -34;
        byArray2[135] = -77;
        byArray2[136] = 11;
        byArray2[137] = 114;
        byArray2[138] = -89;
        byArray2[139] = 28;
        byArray2[140] = -17;
        byArray2[141] = -47;
        byArray2[142] = 83;
        byArray2[143] = 62;
        byArray2[144] = -113;
        byArray2[145] = 51;
        byArray2[146] = 38;
        byArray2[147] = 95;
        byArray2[148] = -20;
        byArray2[149] = 118;
        byArray2[150] = 42;
        byArray2[151] = 73;
        byArray2[152] = -127;
        byArray2[153] = -120;
        byArray2[154] = -18;
        byArray2[155] = 33;
        byArray2[156] = -60;
        byArray2[157] = 26;
        byArray2[158] = -21;
        byArray2[159] = -39;
        byArray2[160] = -59;
        byArray2[161] = 57;
        byArray2[162] = -103;
        byArray2[163] = -51;
        byArray2[164] = -83;
        byArray2[165] = 49;
        byArray2[166] = -117;
        byArray2[167] = 1;
        byArray2[168] = 24;
        byArray2[169] = 35;
        byArray2[170] = -35;
        byArray2[171] = 31;
        byArray2[172] = 78;
        byArray2[173] = 45;
        byArray2[174] = -7;
        byArray2[175] = 72;
        byArray2[176] = 79;
        byArray2[177] = -14;
        byArray2[178] = 101;
        byArray2[179] = -114;
        byArray2[180] = 120;
        byArray2[181] = 92;
        byArray2[182] = 88;
        byArray2[183] = 25;
        byArray2[184] = -115;
        byArray2[185] = -27;
        byArray2[186] = -104;
        byArray2[187] = 87;
        byArray2[188] = 103;
        byArray2[189] = 127;
        byArray2[190] = 5;
        byArray2[191] = 100;
        byArray2[192] = -81;
        byArray2[193] = 99;
        byArray2[194] = -74;
        byArray2[195] = -2;
        byArray2[196] = -11;
        byArray2[197] = -73;
        byArray2[198] = 60;
        byArray2[199] = -91;
        byArray2[200] = -50;
        byArray2[201] = -23;
        byArray2[202] = 104;
        byArray2[203] = 68;
        byArray2[204] = -32;
        byArray2[205] = 77;
        byArray2[206] = 67;
        byArray2[207] = 105;
        byArray2[208] = 41;
        byArray2[209] = 46;
        byArray2[210] = -84;
        byArray2[211] = 21;
        byArray2[212] = 89;
        byArray2[213] = -88;
        byArray2[214] = 10;
        byArray2[215] = -98;
        byArray2[216] = 110;
        byArray2[217] = 71;
        byArray2[218] = -33;
        byArray2[219] = 52;
        byArray2[220] = 53;
        byArray2[221] = 106;
        byArray2[222] = -49;
        byArray2[223] = -36;
        byArray2[224] = 34;
        byArray2[225] = -55;
        byArray2[226] = -64;
        byArray2[227] = -101;
        byArray2[228] = -119;
        byArray2[229] = -44;
        byArray2[230] = -19;
        byArray2[231] = -85;
        byArray2[232] = 18;
        byArray2[233] = -94;
        byArray2[234] = 13;
        byArray2[235] = 82;
        byArray2[236] = -69;
        byArray2[237] = 2;
        byArray2[238] = 47;
        byArray2[239] = -87;
        byArray2[240] = -41;
        byArray2[241] = 97;
        byArray2[242] = 30;
        byArray2[243] = -76;
        byArray2[244] = 80;
        byArray2[245] = 4;
        byArray2[246] = -10;
        byArray2[247] = -62;
        byArray2[248] = 22;
        byArray2[249] = 37;
        byArray2[250] = -122;
        byArray2[251] = 86;
        byArray2[252] = 85;
        byArray2[253] = 9;
        byArray2[254] = -66;
        byArray2[255] = -111;
        byArrayArray[1] = byArray2;
        P = byArrayArray;
    }

    public TwofishEngine() {
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 256));
        int[] m1 = new int[2];
        int[] mX = new int[2];
        int[] mY = new int[2];
        int i = 0;
        while (i < 256) {
            int j;
            m1[0] = j = P[0][i] & 0xFF;
            mX[0] = this.Mx_X(j) & 0xFF;
            mY[0] = this.Mx_Y(j) & 0xFF;
            m1[1] = j = P[1][i] & 0xFF;
            mX[1] = this.Mx_X(j) & 0xFF;
            mY[1] = this.Mx_Y(j) & 0xFF;
            this.gMDS0[i] = m1[1] | mX[1] << 8 | mY[1] << 16 | mY[1] << 24;
            this.gMDS1[i] = mY[0] | mY[0] << 8 | mX[0] << 16 | m1[0] << 24;
            this.gMDS2[i] = mX[1] | mY[1] << 8 | m1[1] << 16 | mY[1] << 24;
            this.gMDS3[i] = mX[0] | m1[0] << 8 | mY[0] << 16 | mX[0] << 24;
            ++i;
        }
    }

    @Override
    public void init(boolean encrypting, CipherParameters params) {
        if (params instanceof KeyParameter) {
            this.encrypting = encrypting;
            this.workingKey = ((KeyParameter)params).getKey();
            int keyBits = this.workingKey.length * 8;
            switch (keyBits) {
                case 128: 
                case 192: 
                case 256: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Key length not 128/192/256 bits.");
                }
            }
            CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), keyBits, params, Utils.getPurpose(encrypting)));
            this.k64Cnt = this.workingKey.length / 8;
            this.setKey(this.workingKey);
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to Twofish init - " + params.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "Twofish";
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.workingKey == null) {
            throw new IllegalStateException("Twofish not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.encrypting) {
            this.encryptBlock(in, inOff, out, outOff);
        } else {
            this.decryptBlock(in, inOff, out, outOff);
        }
        return 16;
    }

    @Override
    public void reset() {
        if (this.workingKey != null) {
            this.setKey(this.workingKey);
        }
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    private void setKey(byte[] key) {
        int[] k32e = new int[4];
        int[] k32o = new int[4];
        int[] sBoxKeys = new int[4];
        this.gSubKeys = new int[40];
        int i = 0;
        while (i < this.k64Cnt) {
            int p = i * 8;
            k32e[i] = Pack.littleEndianToInt(key, p);
            k32o[i] = Pack.littleEndianToInt(key, p + 4);
            sBoxKeys[this.k64Cnt - 1 - i] = this.RS_MDS_Encode(k32e[i], k32o[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < 20) {
            int q = i2 * 0x2020202;
            int A = this.F32(q, k32e);
            int B = this.F32(q + 0x1010101, k32o);
            B = Integers.rotateLeft(B, 8);
            this.gSubKeys[i2 * 2] = A += B;
            this.gSubKeys[i2 * 2 + 1] = (A += B) << 9 | A >>> 23;
            ++i2;
        }
        int k0 = sBoxKeys[0];
        int k1 = sBoxKeys[1];
        int k2 = sBoxKeys[2];
        int k3 = sBoxKeys[3];
        this.gSBox = new int[1024];
        int i3 = 0;
        while (i3 < 256) {
            int b3;
            int b2 = b3 = i3;
            int b1 = b3;
            int b0 = b3;
            switch (this.k64Cnt & 3) {
                case 1: {
                    this.gSBox[i3 * 2] = this.gMDS0[P[0][b0] & 0xFF ^ this.b0(k0)];
                    this.gSBox[i3 * 2 + 1] = this.gMDS1[P[0][b1] & 0xFF ^ this.b1(k0)];
                    this.gSBox[i3 * 2 + 512] = this.gMDS2[P[1][b2] & 0xFF ^ this.b2(k0)];
                    this.gSBox[i3 * 2 + 513] = this.gMDS3[P[1][b3] & 0xFF ^ this.b3(k0)];
                    break;
                }
                case 0: {
                    b0 = P[1][b0] & 0xFF ^ this.b0(k3);
                    b1 = P[0][b1] & 0xFF ^ this.b1(k3);
                    b2 = P[0][b2] & 0xFF ^ this.b2(k3);
                    b3 = P[1][b3] & 0xFF ^ this.b3(k3);
                }
                case 3: {
                    b0 = P[1][b0] & 0xFF ^ this.b0(k2);
                    b1 = P[1][b1] & 0xFF ^ this.b1(k2);
                    b2 = P[0][b2] & 0xFF ^ this.b2(k2);
                    b3 = P[0][b3] & 0xFF ^ this.b3(k2);
                }
                case 2: {
                    this.gSBox[i3 * 2] = this.gMDS0[P[0][P[0][b0] & 0xFF ^ this.b0(k1)] & 0xFF ^ this.b0(k0)];
                    this.gSBox[i3 * 2 + 1] = this.gMDS1[P[0][P[1][b1] & 0xFF ^ this.b1(k1)] & 0xFF ^ this.b1(k0)];
                    this.gSBox[i3 * 2 + 512] = this.gMDS2[P[1][P[0][b2] & 0xFF ^ this.b2(k1)] & 0xFF ^ this.b2(k0)];
                    this.gSBox[i3 * 2 + 513] = this.gMDS3[P[1][P[1][b3] & 0xFF ^ this.b3(k1)] & 0xFF ^ this.b3(k0)];
                }
            }
            ++i3;
        }
    }

    private void encryptBlock(byte[] src, int srcIndex, byte[] dst, int dstIndex) {
        int x0 = Pack.littleEndianToInt(src, srcIndex) ^ this.gSubKeys[0];
        int x1 = Pack.littleEndianToInt(src, srcIndex + 4) ^ this.gSubKeys[1];
        int x2 = Pack.littleEndianToInt(src, srcIndex + 8) ^ this.gSubKeys[2];
        int x3 = Pack.littleEndianToInt(src, srcIndex + 12) ^ this.gSubKeys[3];
        int k = 8;
        int r = 0;
        while (r < 16) {
            int t0 = this.Fe32_0(x0);
            int t1 = this.Fe32_3(x1);
            x2 ^= t0 + t1 + this.gSubKeys[k++];
            x2 = Integers.rotateRight(x2, 1);
            x3 = Integers.rotateLeft(x3, 1) ^ t0 + 2 * t1 + this.gSubKeys[k++];
            t0 = this.Fe32_0(x2);
            t1 = this.Fe32_3(x3);
            x0 ^= t0 + t1 + this.gSubKeys[k++];
            x0 = Integers.rotateRight(x0, 1);
            x1 = Integers.rotateLeft(x1, 1) ^ t0 + 2 * t1 + this.gSubKeys[k++];
            r += 2;
        }
        Pack.intToLittleEndian(x2 ^ this.gSubKeys[4], dst, dstIndex);
        Pack.intToLittleEndian(x3 ^ this.gSubKeys[5], dst, dstIndex + 4);
        Pack.intToLittleEndian(x0 ^ this.gSubKeys[6], dst, dstIndex + 8);
        Pack.intToLittleEndian(x1 ^ this.gSubKeys[7], dst, dstIndex + 12);
    }

    private void decryptBlock(byte[] src, int srcIndex, byte[] dst, int dstIndex) {
        int x2 = Pack.littleEndianToInt(src, srcIndex) ^ this.gSubKeys[4];
        int x3 = Pack.littleEndianToInt(src, srcIndex + 4) ^ this.gSubKeys[5];
        int x0 = Pack.littleEndianToInt(src, srcIndex + 8) ^ this.gSubKeys[6];
        int x1 = Pack.littleEndianToInt(src, srcIndex + 12) ^ this.gSubKeys[7];
        int k = 39;
        int r = 0;
        while (r < 16) {
            int t0 = this.Fe32_0(x2);
            int t1 = this.Fe32_3(x3);
            x1 ^= t0 + 2 * t1 + this.gSubKeys[k--];
            x0 = Integers.rotateLeft(x0, 1) ^ t0 + t1 + this.gSubKeys[k--];
            x1 = Integers.rotateRight(x1, 1);
            t0 = this.Fe32_0(x0);
            t1 = this.Fe32_3(x1);
            x3 ^= t0 + 2 * t1 + this.gSubKeys[k--];
            x2 = Integers.rotateLeft(x2, 1) ^ t0 + t1 + this.gSubKeys[k--];
            x3 = Integers.rotateRight(x3, 1);
            r += 2;
        }
        Pack.intToLittleEndian(x0 ^ this.gSubKeys[0], dst, dstIndex);
        Pack.intToLittleEndian(x1 ^ this.gSubKeys[1], dst, dstIndex + 4);
        Pack.intToLittleEndian(x2 ^ this.gSubKeys[2], dst, dstIndex + 8);
        Pack.intToLittleEndian(x3 ^ this.gSubKeys[3], dst, dstIndex + 12);
    }

    private int F32(int x, int[] k32) {
        int b0 = this.b0(x);
        int b1 = this.b1(x);
        int b2 = this.b2(x);
        int b3 = this.b3(x);
        int k0 = k32[0];
        int k1 = k32[1];
        int k2 = k32[2];
        int k3 = k32[3];
        int result = 0;
        switch (this.k64Cnt & 3) {
            case 1: {
                result = this.gMDS0[P[0][b0] & 0xFF ^ this.b0(k0)] ^ this.gMDS1[P[0][b1] & 0xFF ^ this.b1(k0)] ^ this.gMDS2[P[1][b2] & 0xFF ^ this.b2(k0)] ^ this.gMDS3[P[1][b3] & 0xFF ^ this.b3(k0)];
                break;
            }
            case 0: {
                b0 = P[1][b0] & 0xFF ^ this.b0(k3);
                b1 = P[0][b1] & 0xFF ^ this.b1(k3);
                b2 = P[0][b2] & 0xFF ^ this.b2(k3);
                b3 = P[1][b3] & 0xFF ^ this.b3(k3);
            }
            case 3: {
                b0 = P[1][b0] & 0xFF ^ this.b0(k2);
                b1 = P[1][b1] & 0xFF ^ this.b1(k2);
                b2 = P[0][b2] & 0xFF ^ this.b2(k2);
                b3 = P[0][b3] & 0xFF ^ this.b3(k2);
            }
            case 2: {
                result = this.gMDS0[P[0][P[0][b0] & 0xFF ^ this.b0(k1)] & 0xFF ^ this.b0(k0)] ^ this.gMDS1[P[0][P[1][b1] & 0xFF ^ this.b1(k1)] & 0xFF ^ this.b1(k0)] ^ this.gMDS2[P[1][P[0][b2] & 0xFF ^ this.b2(k1)] & 0xFF ^ this.b2(k0)] ^ this.gMDS3[P[1][P[1][b3] & 0xFF ^ this.b3(k1)] & 0xFF ^ this.b3(k0)];
            }
        }
        return result;
    }

    private int RS_MDS_Encode(int k0, int k1) {
        int r = k1;
        int i = 0;
        while (i < 4) {
            r = this.RS_rem(r);
            ++i;
        }
        r ^= k0;
        i = 0;
        while (i < 4) {
            r = this.RS_rem(r);
            ++i;
        }
        return r;
    }

    private int RS_rem(int x) {
        int b;
        int g2 = (b << 1 ^ (((b = x >>> 24 & 0xFF) & 0x80) != 0 ? 333 : 0)) & 0xFF;
        int g3 = b >>> 1 ^ ((b & 1) != 0 ? 166 : 0) ^ g2;
        return x << 8 ^ g3 << 24 ^ g2 << 16 ^ g3 << 8 ^ b;
    }

    private int LFSR1(int x) {
        return x >> 1 ^ ((x & 1) != 0 ? 180 : 0);
    }

    private int LFSR2(int x) {
        return x >> 2 ^ ((x & 2) != 0 ? 180 : 0) ^ ((x & 1) != 0 ? 90 : 0);
    }

    private int Mx_X(int x) {
        return x ^ this.LFSR2(x);
    }

    private int Mx_Y(int x) {
        return x ^ this.LFSR1(x) ^ this.LFSR2(x);
    }

    private int b0(int x) {
        return x & 0xFF;
    }

    private int b1(int x) {
        return x >>> 8 & 0xFF;
    }

    private int b2(int x) {
        return x >>> 16 & 0xFF;
    }

    private int b3(int x) {
        return x >>> 24 & 0xFF;
    }

    private int Fe32_0(int x) {
        return this.gSBox[0 + 2 * (x & 0xFF)] ^ this.gSBox[1 + 2 * (x >>> 8 & 0xFF)] ^ this.gSBox[512 + 2 * (x >>> 16 & 0xFF)] ^ this.gSBox[513 + 2 * (x >>> 24 & 0xFF)];
    }

    private int Fe32_3(int x) {
        return this.gSBox[0 + 2 * (x >>> 24 & 0xFF)] ^ this.gSBox[1 + 2 * (x & 0xFF)] ^ this.gSBox[512 + 2 * (x >>> 8 & 0xFF)] ^ this.gSBox[513 + 2 * (x >>> 16 & 0xFF)];
    }
}

