/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.engines.AEADBufferBaseEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public class XoodyakEngine
extends AEADBufferBaseEngine {
    private byte[] state;
    private int phase;
    private MODE mode;
    private final int f_bPrime_1 = 47;
    private byte[] K;
    private byte[] iv;
    private final int PhaseUp = 2;
    private final int[] RC = new int[]{88, 56, 960, 208, 288, 20, 96, 44, 896, 240, 416, 18};
    private boolean encrypted;
    private byte aadcd;

    public XoodyakEngine() {
        this.algorithmName = "Xoodyak AEAD";
        this.KEY_SIZE = 16;
        this.IV_SIZE = 16;
        this.MAC_SIZE = 16;
        this.BlockSize = 24;
        this.AADBufferSize = 44;
        this.m_aad = new byte[this.AADBufferSize];
    }

    @Override
    public void init(byte[] key, byte[] iv) throws IllegalArgumentException {
        this.K = key;
        this.iv = iv;
        this.state = new byte[48];
        this.mac = new byte[this.MAC_SIZE];
        this.m_buf = new byte[this.BlockSize + (this.forEncryption ? 0 : this.MAC_SIZE)];
        this.initialised = true;
        this.m_state = this.forEncryption ? AEADBufferBaseEngine.State.EncInit : AEADBufferBaseEngine.State.DecInit;
        this.reset();
    }

    @Override
    protected void processBufferAAD(byte[] input, int inOff) {
        this.AbsorbAny(input, inOff, this.AADBufferSize, this.aadcd);
        this.aadcd = 0;
    }

    @Override
    protected void processFinalAAD() {
        if (this.mode != MODE.ModeKeyed) {
            throw new IllegalArgumentException("Xoodyak has not been initialised");
        }
        if (!this.aadFinished) {
            this.AbsorbAny(this.m_aad, 0, this.m_aadPos, this.aadcd);
            this.aadFinished = true;
            this.m_aadPos = 0;
        }
    }

    @Override
    protected void processBuffer(byte[] input, int inOff, byte[] output, int outOff) {
        this.processFinalAAD();
        this.encrypt(input, inOff, this.BlockSize, output, outOff);
    }

    private void encrypt(byte[] input, int inOff, int len, byte[] output, int outOff) {
        int IOLen = len;
        byte[] P = new byte[this.BlockSize];
        int Cu = this.encrypted ? 0 : 128;
        while (IOLen != 0 || !this.encrypted) {
            int splitLen = Math.min(IOLen, this.BlockSize);
            if (this.forEncryption) {
                System.arraycopy(input, inOff, P, 0, splitLen);
            }
            this.Up(null, 0, Cu);
            int i = 0;
            while (i < splitLen) {
                output[outOff + i] = (byte)(input[inOff++] ^ this.state[i]);
                ++i;
            }
            if (this.forEncryption) {
                this.Down(P, 0, splitLen, 0);
            } else {
                this.Down(output, outOff, splitLen, 0);
            }
            Cu = 0;
            outOff += splitLen;
            IOLen -= splitLen;
            this.encrypted = true;
        }
    }

    @Override
    protected void processFinalBlock(byte[] output, int outOff) {
        this.processFinalAAD();
        if (this.forEncryption) {
            Arrays.fill(this.m_buf, this.m_bufPos, this.BlockSize, (byte)0);
        }
        this.encrypt(this.m_buf, 0, this.m_bufPos, output, outOff);
        this.mac = new byte[this.MAC_SIZE];
        this.Up(this.mac, this.MAC_SIZE, 64);
    }

    @Override
    protected void reset(boolean clearMac) {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        Arrays.fill(this.state, (byte)0);
        this.aadFinished = false;
        this.encrypted = false;
        this.phase = 2;
        Arrays.fill(this.m_buf, (byte)0);
        Arrays.fill(this.m_aad, (byte)0);
        this.m_bufPos = 0;
        this.m_aadPos = 0;
        this.aadcd = (byte)3;
        int KLen = this.K.length;
        int IDLen = this.iv.length;
        byte[] KID = new byte[this.AADBufferSize];
        this.mode = MODE.ModeKeyed;
        System.arraycopy(this.K, 0, KID, 0, KLen);
        System.arraycopy(this.iv, 0, KID, KLen, IDLen);
        KID[KLen + IDLen] = (byte)IDLen;
        this.AbsorbAny(KID, 0, KLen + IDLen + 1, 2);
        super.reset(clearMac);
    }

    private void AbsorbAny(byte[] X, int Xoff, int XLen, int Cd) {
        int splitLen;
        do {
            if (this.phase != 2) {
                this.Up(null, 0, 0);
            }
            splitLen = Math.min(XLen, this.AADBufferSize);
            this.Down(X, Xoff, splitLen, Cd);
            Cd = 0;
            Xoff += splitLen;
        } while ((XLen -= splitLen) != 0);
    }

    private void Up(byte[] Yi, int YiLen, int Cu) {
        if (this.mode != MODE.ModeHash) {
            this.state[47] = (byte)(this.state[47] ^ Cu);
        }
        int a0 = Pack.littleEndianToInt(this.state, 0);
        int a1 = Pack.littleEndianToInt(this.state, 4);
        int a2 = Pack.littleEndianToInt(this.state, 8);
        int a3 = Pack.littleEndianToInt(this.state, 12);
        int a4 = Pack.littleEndianToInt(this.state, 16);
        int a5 = Pack.littleEndianToInt(this.state, 20);
        int a6 = Pack.littleEndianToInt(this.state, 24);
        int a7 = Pack.littleEndianToInt(this.state, 28);
        int a8 = Pack.littleEndianToInt(this.state, 32);
        int a9 = Pack.littleEndianToInt(this.state, 36);
        int a10 = Pack.littleEndianToInt(this.state, 40);
        int a11 = Pack.littleEndianToInt(this.state, 44);
        int i = 0;
        while (i < 12) {
            int p0 = a0 ^ a4 ^ a8;
            int p1 = a1 ^ a5 ^ a9;
            int p2 = a2 ^ a6 ^ a10;
            int p3 = a3 ^ a7 ^ a11;
            int e0 = Integers.rotateLeft(p3, 5) ^ Integers.rotateLeft(p3, 14);
            int e1 = Integers.rotateLeft(p0, 5) ^ Integers.rotateLeft(p0, 14);
            int e2 = Integers.rotateLeft(p1, 5) ^ Integers.rotateLeft(p1, 14);
            int e3 = Integers.rotateLeft(p2, 5) ^ Integers.rotateLeft(p2, 14);
            a0 ^= e0;
            a4 ^= e0;
            a8 ^= e0;
            a1 ^= e1;
            a5 ^= e1;
            a9 ^= e1;
            a2 ^= e2;
            a6 ^= e2;
            a10 ^= e2;
            a3 ^= e3;
            a7 ^= e3;
            a11 ^= e3;
            int b0 = a0;
            int b1 = a1;
            int b2 = a2;
            int b3 = a3;
            int b4 = a7;
            int b5 = a4;
            int b6 = a5;
            int b7 = a6;
            int b8 = Integers.rotateLeft(a8, 11);
            int b9 = Integers.rotateLeft(a9, 11);
            int b10 = Integers.rotateLeft(a10, 11);
            int b11 = Integers.rotateLeft(a11, 11);
            a0 = (b0 ^= this.RC[i]) ^ ~b4 & b8;
            a1 = b1 ^ ~b5 & b9;
            a2 = b2 ^ ~b6 & b10;
            a3 = b3 ^ ~b7 & b11;
            a4 = b4 ^ ~b8 & b0;
            a5 = b5 ^ ~b9 & b1;
            a6 = b6 ^ ~b10 & b2;
            a7 = b7 ^ ~b11 & b3;
            b8 ^= ~b0 & b4;
            b9 ^= ~b1 & b5;
            b10 ^= ~b2 & b6;
            b11 ^= ~b3 & b7;
            a4 = Integers.rotateLeft(a4, 1);
            a5 = Integers.rotateLeft(a5, 1);
            a6 = Integers.rotateLeft(a6, 1);
            a7 = Integers.rotateLeft(a7, 1);
            a8 = Integers.rotateLeft(b10, 8);
            a9 = Integers.rotateLeft(b11, 8);
            a10 = Integers.rotateLeft(b8, 8);
            a11 = Integers.rotateLeft(b9, 8);
            ++i;
        }
        Pack.intToLittleEndian(a0, this.state, 0);
        Pack.intToLittleEndian(a1, this.state, 4);
        Pack.intToLittleEndian(a2, this.state, 8);
        Pack.intToLittleEndian(a3, this.state, 12);
        Pack.intToLittleEndian(a4, this.state, 16);
        Pack.intToLittleEndian(a5, this.state, 20);
        Pack.intToLittleEndian(a6, this.state, 24);
        Pack.intToLittleEndian(a7, this.state, 28);
        Pack.intToLittleEndian(a8, this.state, 32);
        Pack.intToLittleEndian(a9, this.state, 36);
        Pack.intToLittleEndian(a10, this.state, 40);
        Pack.intToLittleEndian(a11, this.state, 44);
        this.phase = 2;
        if (Yi != null) {
            System.arraycopy(this.state, 0, Yi, 0, YiLen);
        }
    }

    void Down(byte[] Xi, int XiOff, int XiLen, int Cd) {
        int i = 0;
        while (i < XiLen) {
            int n = i++;
            this.state[n] = (byte)(this.state[n] ^ Xi[XiOff++]);
        }
        int n = XiLen;
        this.state[n] = (byte)(this.state[n] ^ 1);
        this.state[47] = (byte)(this.state[47] ^ (this.mode == MODE.ModeHash ? Cd & 1 : Cd));
        this.phase = 1;
    }

    static enum MODE {
        ModeHash,
        ModeKeyed;

    }
}

