/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.threshold;

import org.bouncycastle.crypto.threshold.Polynomial;
import org.bouncycastle.crypto.threshold.ShamirSecretSplitter;

class PolynomialTable
extends Polynomial {
    private final byte[] LOG;
    private final byte[] EXP;
    private static final byte[] AES_LOG;
    private static final byte[] AES_EXP;
    private static final byte[] RSA_LOG;
    private static final byte[] RSA_EXP;

    static {
        byte[] byArray = new byte[256];
        byArray[1] = -1;
        byArray[2] = 25;
        byArray[3] = 1;
        byArray[4] = 50;
        byArray[5] = 2;
        byArray[6] = 26;
        byArray[7] = -58;
        byArray[8] = 75;
        byArray[9] = -57;
        byArray[10] = 27;
        byArray[11] = 104;
        byArray[12] = 51;
        byArray[13] = -18;
        byArray[14] = -33;
        byArray[15] = 3;
        byArray[16] = 100;
        byArray[17] = 4;
        byArray[18] = -32;
        byArray[19] = 14;
        byArray[20] = 52;
        byArray[21] = -115;
        byArray[22] = -127;
        byArray[23] = -17;
        byArray[24] = 76;
        byArray[25] = 113;
        byArray[26] = 8;
        byArray[27] = -56;
        byArray[28] = -8;
        byArray[29] = 105;
        byArray[30] = 28;
        byArray[31] = -63;
        byArray[32] = 125;
        byArray[33] = -62;
        byArray[34] = 29;
        byArray[35] = -75;
        byArray[36] = -7;
        byArray[37] = -71;
        byArray[38] = 39;
        byArray[39] = 106;
        byArray[40] = 77;
        byArray[41] = -28;
        byArray[42] = -90;
        byArray[43] = 114;
        byArray[44] = -102;
        byArray[45] = -55;
        byArray[46] = 9;
        byArray[47] = 120;
        byArray[48] = 101;
        byArray[49] = 47;
        byArray[50] = -118;
        byArray[51] = 5;
        byArray[52] = 33;
        byArray[53] = 15;
        byArray[54] = -31;
        byArray[55] = 36;
        byArray[56] = 18;
        byArray[57] = -16;
        byArray[58] = -126;
        byArray[59] = 69;
        byArray[60] = 53;
        byArray[61] = -109;
        byArray[62] = -38;
        byArray[63] = -114;
        byArray[64] = -106;
        byArray[65] = -113;
        byArray[66] = -37;
        byArray[67] = -67;
        byArray[68] = 54;
        byArray[69] = -48;
        byArray[70] = -50;
        byArray[71] = -108;
        byArray[72] = 19;
        byArray[73] = 92;
        byArray[74] = -46;
        byArray[75] = -15;
        byArray[76] = 64;
        byArray[77] = 70;
        byArray[78] = -125;
        byArray[79] = 56;
        byArray[80] = 102;
        byArray[81] = -35;
        byArray[82] = -3;
        byArray[83] = 48;
        byArray[84] = -65;
        byArray[85] = 6;
        byArray[86] = -117;
        byArray[87] = 98;
        byArray[88] = -77;
        byArray[89] = 37;
        byArray[90] = -30;
        byArray[91] = -104;
        byArray[92] = 34;
        byArray[93] = -120;
        byArray[94] = -111;
        byArray[95] = 16;
        byArray[96] = 126;
        byArray[97] = 110;
        byArray[98] = 72;
        byArray[99] = -61;
        byArray[100] = -93;
        byArray[101] = -74;
        byArray[102] = 30;
        byArray[103] = 66;
        byArray[104] = 58;
        byArray[105] = 107;
        byArray[106] = 40;
        byArray[107] = 84;
        byArray[108] = -6;
        byArray[109] = -123;
        byArray[110] = 61;
        byArray[111] = -70;
        byArray[112] = 43;
        byArray[113] = 121;
        byArray[114] = 10;
        byArray[115] = 21;
        byArray[116] = -101;
        byArray[117] = -97;
        byArray[118] = 94;
        byArray[119] = -54;
        byArray[120] = 78;
        byArray[121] = -44;
        byArray[122] = -84;
        byArray[123] = -27;
        byArray[124] = -13;
        byArray[125] = 115;
        byArray[126] = -89;
        byArray[127] = 87;
        byArray[128] = -81;
        byArray[129] = 88;
        byArray[130] = -88;
        byArray[131] = 80;
        byArray[132] = -12;
        byArray[133] = -22;
        byArray[134] = -42;
        byArray[135] = 116;
        byArray[136] = 79;
        byArray[137] = -82;
        byArray[138] = -23;
        byArray[139] = -43;
        byArray[140] = -25;
        byArray[141] = -26;
        byArray[142] = -83;
        byArray[143] = -24;
        byArray[144] = 44;
        byArray[145] = -41;
        byArray[146] = 117;
        byArray[147] = 122;
        byArray[148] = -21;
        byArray[149] = 22;
        byArray[150] = 11;
        byArray[151] = -11;
        byArray[152] = 89;
        byArray[153] = -53;
        byArray[154] = 95;
        byArray[155] = -80;
        byArray[156] = -100;
        byArray[157] = -87;
        byArray[158] = 81;
        byArray[159] = -96;
        byArray[160] = 127;
        byArray[161] = 12;
        byArray[162] = -10;
        byArray[163] = 111;
        byArray[164] = 23;
        byArray[165] = -60;
        byArray[166] = 73;
        byArray[167] = -20;
        byArray[168] = -40;
        byArray[169] = 67;
        byArray[170] = 31;
        byArray[171] = 45;
        byArray[172] = -92;
        byArray[173] = 118;
        byArray[174] = 123;
        byArray[175] = -73;
        byArray[176] = -52;
        byArray[177] = -69;
        byArray[178] = 62;
        byArray[179] = 90;
        byArray[180] = -5;
        byArray[181] = 96;
        byArray[182] = -79;
        byArray[183] = -122;
        byArray[184] = 59;
        byArray[185] = 82;
        byArray[186] = -95;
        byArray[187] = 108;
        byArray[188] = -86;
        byArray[189] = 85;
        byArray[190] = 41;
        byArray[191] = -99;
        byArray[192] = -105;
        byArray[193] = -78;
        byArray[194] = -121;
        byArray[195] = -112;
        byArray[196] = 97;
        byArray[197] = -66;
        byArray[198] = -36;
        byArray[199] = -4;
        byArray[200] = -68;
        byArray[201] = -107;
        byArray[202] = -49;
        byArray[203] = -51;
        byArray[204] = 55;
        byArray[205] = 63;
        byArray[206] = 91;
        byArray[207] = -47;
        byArray[208] = 83;
        byArray[209] = 57;
        byArray[210] = -124;
        byArray[211] = 60;
        byArray[212] = 65;
        byArray[213] = -94;
        byArray[214] = 109;
        byArray[215] = 71;
        byArray[216] = 20;
        byArray[217] = 42;
        byArray[218] = -98;
        byArray[219] = 93;
        byArray[220] = 86;
        byArray[221] = -14;
        byArray[222] = -45;
        byArray[223] = -85;
        byArray[224] = 68;
        byArray[225] = 17;
        byArray[226] = -110;
        byArray[227] = -39;
        byArray[228] = 35;
        byArray[229] = 32;
        byArray[230] = 46;
        byArray[231] = -119;
        byArray[232] = -76;
        byArray[233] = 124;
        byArray[234] = -72;
        byArray[235] = 38;
        byArray[236] = 119;
        byArray[237] = -103;
        byArray[238] = -29;
        byArray[239] = -91;
        byArray[240] = 103;
        byArray[241] = 74;
        byArray[242] = -19;
        byArray[243] = -34;
        byArray[244] = -59;
        byArray[245] = 49;
        byArray[246] = -2;
        byArray[247] = 24;
        byArray[248] = 13;
        byArray[249] = 99;
        byArray[250] = -116;
        byArray[251] = -128;
        byArray[252] = -64;
        byArray[253] = -9;
        byArray[254] = 112;
        byArray[255] = 7;
        AES_LOG = byArray;
        AES_EXP = new byte[]{1, 3, 5, 15, 17, 51, 85, -1, 26, 46, 114, -106, -95, -8, 19, 53, 95, -31, 56, 72, -40, 115, -107, -92, -9, 2, 6, 10, 30, 34, 102, -86, -27, 52, 92, -28, 55, 89, -21, 38, 106, -66, -39, 112, -112, -85, -26, 49, 83, -11, 4, 12, 20, 60, 68, -52, 79, -47, 104, -72, -45, 110, -78, -51, 76, -44, 103, -87, -32, 59, 77, -41, 98, -90, -15, 8, 24, 40, 120, -120, -125, -98, -71, -48, 107, -67, -36, 127, -127, -104, -77, -50, 73, -37, 118, -102, -75, -60, 87, -7, 16, 48, 80, -16, 11, 29, 39, 105, -69, -42, 97, -93, -2, 25, 43, 125, -121, -110, -83, -20, 47, 113, -109, -82, -23, 32, 96, -96, -5, 22, 58, 78, -46, 109, -73, -62, 93, -25, 50, 86, -6, 21, 63, 65, -61, 94, -30, 61, 71, -55, 64, -64, 91, -19, 44, 116, -100, -65, -38, 117, -97, -70, -43, 100, -84, -17, 42, 126, -126, -99, -68, -33, 122, -114, -119, -128, -101, -74, -63, 88, -24, 35, 101, -81, -22, 37, 111, -79, -56, 67, -59, 84, -4, 31, 33, 99, -91, -12, 7, 9, 27, 45, 119, -103, -80, -53, 70, -54, 69, -49, 74, -34, 121, -117, -122, -111, -88, -29, 62, 66, -58, 81, -13, 14, 18, 54, 90, -18, 41, 123, -115, -116, -113, -118, -123, -108, -89, -14, 13, 23, 57, 75, -35, 124, -124, -105, -94, -3, 28, 36, 108, -76, -57, 82, -10, 1};
        byte[] byArray2 = new byte[256];
        byArray2[0] = -1;
        byArray2[2] = 1;
        byArray2[3] = 25;
        byArray2[4] = 2;
        byArray2[5] = 50;
        byArray2[6] = 26;
        byArray2[7] = -58;
        byArray2[8] = 3;
        byArray2[9] = -33;
        byArray2[10] = 51;
        byArray2[11] = -18;
        byArray2[12] = 27;
        byArray2[13] = 104;
        byArray2[14] = -57;
        byArray2[15] = 75;
        byArray2[16] = 4;
        byArray2[17] = 100;
        byArray2[18] = -32;
        byArray2[19] = 14;
        byArray2[20] = 52;
        byArray2[21] = -115;
        byArray2[22] = -17;
        byArray2[23] = -127;
        byArray2[24] = 28;
        byArray2[25] = -63;
        byArray2[26] = 105;
        byArray2[27] = -8;
        byArray2[28] = -56;
        byArray2[29] = 8;
        byArray2[30] = 76;
        byArray2[31] = 113;
        byArray2[32] = 5;
        byArray2[33] = -118;
        byArray2[34] = 101;
        byArray2[35] = 47;
        byArray2[36] = -31;
        byArray2[37] = 36;
        byArray2[38] = 15;
        byArray2[39] = 33;
        byArray2[40] = 53;
        byArray2[41] = -109;
        byArray2[42] = -114;
        byArray2[43] = -38;
        byArray2[44] = -16;
        byArray2[45] = 18;
        byArray2[46] = -126;
        byArray2[47] = 69;
        byArray2[48] = 29;
        byArray2[49] = -75;
        byArray2[50] = -62;
        byArray2[51] = 125;
        byArray2[52] = 106;
        byArray2[53] = 39;
        byArray2[54] = -7;
        byArray2[55] = -71;
        byArray2[56] = -55;
        byArray2[57] = -102;
        byArray2[58] = 9;
        byArray2[59] = 120;
        byArray2[60] = 77;
        byArray2[61] = -28;
        byArray2[62] = 114;
        byArray2[63] = -90;
        byArray2[64] = 6;
        byArray2[65] = -65;
        byArray2[66] = -117;
        byArray2[67] = 98;
        byArray2[68] = 102;
        byArray2[69] = -35;
        byArray2[70] = 48;
        byArray2[71] = -3;
        byArray2[72] = -30;
        byArray2[73] = -104;
        byArray2[74] = 37;
        byArray2[75] = -77;
        byArray2[76] = 16;
        byArray2[77] = -111;
        byArray2[78] = 34;
        byArray2[79] = -120;
        byArray2[80] = 54;
        byArray2[81] = -48;
        byArray2[82] = -108;
        byArray2[83] = -50;
        byArray2[84] = -113;
        byArray2[85] = -106;
        byArray2[86] = -37;
        byArray2[87] = -67;
        byArray2[88] = -15;
        byArray2[89] = -46;
        byArray2[90] = 19;
        byArray2[91] = 92;
        byArray2[92] = -125;
        byArray2[93] = 56;
        byArray2[94] = 70;
        byArray2[95] = 64;
        byArray2[96] = 30;
        byArray2[97] = 66;
        byArray2[98] = -74;
        byArray2[99] = -93;
        byArray2[100] = -61;
        byArray2[101] = 72;
        byArray2[102] = 126;
        byArray2[103] = 110;
        byArray2[104] = 107;
        byArray2[105] = 58;
        byArray2[106] = 40;
        byArray2[107] = 84;
        byArray2[108] = -6;
        byArray2[109] = -123;
        byArray2[110] = -70;
        byArray2[111] = 61;
        byArray2[112] = -54;
        byArray2[113] = 94;
        byArray2[114] = -101;
        byArray2[115] = -97;
        byArray2[116] = 10;
        byArray2[117] = 21;
        byArray2[118] = 121;
        byArray2[119] = 43;
        byArray2[120] = 78;
        byArray2[121] = -44;
        byArray2[122] = -27;
        byArray2[123] = -84;
        byArray2[124] = 115;
        byArray2[125] = -13;
        byArray2[126] = -89;
        byArray2[127] = 87;
        byArray2[128] = 7;
        byArray2[129] = 112;
        byArray2[130] = -64;
        byArray2[131] = -9;
        byArray2[132] = -116;
        byArray2[133] = -128;
        byArray2[134] = 99;
        byArray2[135] = 13;
        byArray2[136] = 103;
        byArray2[137] = 74;
        byArray2[138] = -34;
        byArray2[139] = -19;
        byArray2[140] = 49;
        byArray2[141] = -59;
        byArray2[142] = -2;
        byArray2[143] = 24;
        byArray2[144] = -29;
        byArray2[145] = -91;
        byArray2[146] = -103;
        byArray2[147] = 119;
        byArray2[148] = 38;
        byArray2[149] = -72;
        byArray2[150] = -76;
        byArray2[151] = 124;
        byArray2[152] = 17;
        byArray2[153] = 68;
        byArray2[154] = -110;
        byArray2[155] = -39;
        byArray2[156] = 35;
        byArray2[157] = 32;
        byArray2[158] = -119;
        byArray2[159] = 46;
        byArray2[160] = 55;
        byArray2[161] = 63;
        byArray2[162] = -47;
        byArray2[163] = 91;
        byArray2[164] = -107;
        byArray2[165] = -68;
        byArray2[166] = -49;
        byArray2[167] = -51;
        byArray2[168] = -112;
        byArray2[169] = -121;
        byArray2[170] = -105;
        byArray2[171] = -78;
        byArray2[172] = -36;
        byArray2[173] = -4;
        byArray2[174] = -66;
        byArray2[175] = 97;
        byArray2[176] = -14;
        byArray2[177] = 86;
        byArray2[178] = -45;
        byArray2[179] = -85;
        byArray2[180] = 20;
        byArray2[181] = 42;
        byArray2[182] = 93;
        byArray2[183] = -98;
        byArray2[184] = -124;
        byArray2[185] = 60;
        byArray2[186] = 57;
        byArray2[187] = 83;
        byArray2[188] = 71;
        byArray2[189] = 109;
        byArray2[190] = 65;
        byArray2[191] = -94;
        byArray2[192] = 31;
        byArray2[193] = 45;
        byArray2[194] = 67;
        byArray2[195] = -40;
        byArray2[196] = -73;
        byArray2[197] = 123;
        byArray2[198] = -92;
        byArray2[199] = 118;
        byArray2[200] = -60;
        byArray2[201] = 23;
        byArray2[202] = 73;
        byArray2[203] = -20;
        byArray2[204] = 127;
        byArray2[205] = 12;
        byArray2[206] = 111;
        byArray2[207] = -10;
        byArray2[208] = 108;
        byArray2[209] = -95;
        byArray2[210] = 59;
        byArray2[211] = 82;
        byArray2[212] = 41;
        byArray2[213] = -99;
        byArray2[214] = 85;
        byArray2[215] = -86;
        byArray2[216] = -5;
        byArray2[217] = 96;
        byArray2[218] = -122;
        byArray2[219] = -79;
        byArray2[220] = -69;
        byArray2[221] = -52;
        byArray2[222] = 62;
        byArray2[223] = 90;
        byArray2[224] = -53;
        byArray2[225] = 89;
        byArray2[226] = 95;
        byArray2[227] = -80;
        byArray2[228] = -100;
        byArray2[229] = -87;
        byArray2[230] = -96;
        byArray2[231] = 81;
        byArray2[232] = 11;
        byArray2[233] = -11;
        byArray2[234] = 22;
        byArray2[235] = -21;
        byArray2[236] = 122;
        byArray2[237] = 117;
        byArray2[238] = 44;
        byArray2[239] = -41;
        byArray2[240] = 79;
        byArray2[241] = -82;
        byArray2[242] = -43;
        byArray2[243] = -23;
        byArray2[244] = -26;
        byArray2[245] = -25;
        byArray2[246] = -83;
        byArray2[247] = -24;
        byArray2[248] = 116;
        byArray2[249] = -42;
        byArray2[250] = -12;
        byArray2[251] = -22;
        byArray2[252] = -88;
        byArray2[253] = 80;
        byArray2[254] = 88;
        byArray2[255] = -81;
        RSA_LOG = byArray2;
        RSA_EXP = new byte[]{1, 2, 4, 8, 16, 32, 64, -128, 29, 58, 116, -24, -51, -121, 19, 38, 76, -104, 45, 90, -76, 117, -22, -55, -113, 3, 6, 12, 24, 48, 96, -64, -99, 39, 78, -100, 37, 74, -108, 53, 106, -44, -75, 119, -18, -63, -97, 35, 70, -116, 5, 10, 20, 40, 80, -96, 93, -70, 105, -46, -71, 111, -34, -95, 95, -66, 97, -62, -103, 47, 94, -68, 101, -54, -119, 15, 30, 60, 120, -16, -3, -25, -45, -69, 107, -42, -79, 127, -2, -31, -33, -93, 91, -74, 113, -30, -39, -81, 67, -122, 17, 34, 68, -120, 13, 26, 52, 104, -48, -67, 103, -50, -127, 31, 62, 124, -8, -19, -57, -109, 59, 118, -20, -59, -105, 51, 102, -52, -123, 23, 46, 92, -72, 109, -38, -87, 79, -98, 33, 66, -124, 21, 42, 84, -88, 77, -102, 41, 82, -92, 85, -86, 73, -110, 57, 114, -28, -43, -73, 115, -26, -47, -65, 99, -58, -111, 63, 126, -4, -27, -41, -77, 123, -10, -15, -1, -29, -37, -85, 75, -106, 49, 98, -60, -107, 55, 110, -36, -91, 87, -82, 65, -126, 25, 50, 100, -56, -115, 7, 14, 28, 56, 112, -32, -35, -89, 83, -90, 81, -94, 89, -78, 121, -14, -7, -17, -61, -101, 43, 86, -84, 69, -118, 9, 18, 36, 72, -112, 61, 122, -12, -11, -9, -13, -5, -21, -53, -117, 11, 22, 44, 88, -80, 125, -6, -23, -49, -125, 27, 54, 108, -40, -83, 71, -114, 1};
    }

    public PolynomialTable(ShamirSecretSplitter.Algorithm algorithm) {
        switch (algorithm) {
            case AES: {
                this.LOG = AES_LOG;
                this.EXP = AES_EXP;
                break;
            }
            case RSA: {
                this.LOG = RSA_LOG;
                this.EXP = RSA_EXP;
                break;
            }
            default: {
                throw new IllegalArgumentException("The algorithm is not correct");
            }
        }
    }

    @Override
    protected byte gfMul(int x, int y) {
        if (x == 0 || y == 0) {
            return 0;
        }
        return (byte)(this.EXP[((this.LOG[x] & 0xFF) + (this.LOG[y] & 0xFF)) % 255] & 0xFF);
    }

    @Override
    protected byte gfDiv(int x, int y) {
        if (x == 0) {
            return 0;
        }
        return this.EXP[((this.LOG[x] & 0xFF) - (this.LOG[y] & 0xFF) + 255) % 255];
    }
}

