/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.threshold;

import java.io.IOException;
import org.bouncycastle.crypto.threshold.Polynomial;
import org.bouncycastle.crypto.threshold.ShamirSecretSplitter;
import org.bouncycastle.crypto.threshold.ShamirSplitSecretShare;
import org.bouncycastle.crypto.threshold.SplitSecret;

public class ShamirSplitSecret
implements SplitSecret {
    private final ShamirSplitSecretShare[] secretShares;
    private final Polynomial poly;

    public ShamirSplitSecret(ShamirSecretSplitter.Algorithm algorithm, ShamirSecretSplitter.Mode mode, ShamirSplitSecretShare[] secretShares) {
        this.secretShares = secretShares;
        this.poly = Polynomial.newInstance(algorithm, mode);
    }

    ShamirSplitSecret(Polynomial poly, ShamirSplitSecretShare[] secretShares) {
        this.secretShares = secretShares;
        this.poly = poly;
    }

    public ShamirSplitSecretShare[] getSecretShares() {
        return this.secretShares;
    }

    public ShamirSplitSecret multiple(int mul) throws IOException {
        int i = 0;
        while (i < this.secretShares.length) {
            byte[] ss = this.secretShares[i].getEncoded();
            int j = 0;
            while (j < ss.length) {
                ss[j] = this.poly.gfMul(ss[j] & 0xFF, mul);
                ++j;
            }
            this.secretShares[i] = new ShamirSplitSecretShare(ss, i + 1);
            ++i;
        }
        return this;
    }

    public ShamirSplitSecret divide(int div) throws IOException {
        int i = 0;
        while (i < this.secretShares.length) {
            byte[] ss = this.secretShares[i].getEncoded();
            int j = 0;
            while (j < ss.length) {
                ss[j] = this.poly.gfDiv(ss[j] & 0xFF, div);
                ++j;
            }
            this.secretShares[i] = new ShamirSplitSecretShare(ss, i + 1);
            ++i;
        }
        return this;
    }

    @Override
    public byte[] getSecret() throws IOException {
        int n = this.secretShares.length;
        byte[] r = new byte[n];
        byte[] products = new byte[n - 1];
        byte[][] splits = new byte[n][this.secretShares[0].getEncoded().length];
        int i = 0;
        while (i < n) {
            splits[i] = this.secretShares[i].getEncoded();
            int tmp = 0;
            int j = 0;
            while (j < n) {
                if (j != i) {
                    int n2 = tmp;
                    tmp = (byte)(n2 + 1);
                    products[n2] = this.poly.gfDiv(this.secretShares[j].r, this.secretShares[i].r ^ this.secretShares[j].r);
                }
                ++j;
            }
            tmp = 1;
            int prdI = 0;
            while (prdI != products.length) {
                tmp = this.poly.gfMul(tmp & 0xFF, products[prdI] & 0xFF);
                ++prdI;
            }
            r[i] = tmp;
            ++i;
        }
        return this.poly.gfVecMul(r, splits);
    }
}

