/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

import org.bouncycastle.pqc.crypto.cmce.BENES;
import org.bouncycastle.pqc.crypto.cmce.Utils;

class BENES12
extends BENES {
    public BENES12(int n, int t, int m) {
        super(n, t, m);
    }

    static void layerBenes(long[] data, long[] bits, int lgs) {
        int bit_ptr = 0;
        int s = 1 << lgs;
        int i = 0;
        while (i < 64) {
            int j = i;
            while (j < i + s) {
                long d = data[j + 0] ^ data[j + s];
                int n = bit_ptr++;
                int n2 = j + 0;
                data[n2] = data[n2] ^ (d &= bits[n]);
                int n3 = j + s;
                data[n3] = data[n3] ^ d;
                ++j;
            }
            i += s * 2;
        }
    }

    private void apply_benes(byte[] r, byte[] bits, int rev) {
        int cond_ptr;
        int inc;
        long[] bs = new long[64];
        long[] cond = new long[64];
        int i = 0;
        while (i < 64) {
            bs[i] = Utils.load8(r, i * 8);
            ++i;
        }
        if (rev == 0) {
            inc = 256;
            cond_ptr = this.SYS_T * 2 + 40;
        } else {
            inc = -256;
            cond_ptr = this.SYS_T * 2 + 40 + (2 * this.GFBITS - 2) * 256;
        }
        BENES12.transpose_64x64(bs, bs);
        int low = 0;
        while (low <= 5) {
            i = 0;
            while (i < 64) {
                cond[i] = Utils.load4(bits, cond_ptr + i * 4);
                ++i;
            }
            BENES12.transpose_64x64(cond, cond);
            BENES12.layerBenes(bs, cond, low);
            cond_ptr += inc;
            ++low;
        }
        BENES12.transpose_64x64(bs, bs);
        low = 0;
        while (low <= 5) {
            i = 0;
            while (i < 32) {
                cond[i] = Utils.load8(bits, cond_ptr + i * 8);
                ++i;
            }
            BENES12.layerBenes(bs, cond, low);
            cond_ptr += inc;
            ++low;
        }
        low = 4;
        while (low >= 0) {
            i = 0;
            while (i < 32) {
                cond[i] = Utils.load8(bits, cond_ptr + i * 8);
                ++i;
            }
            BENES12.layerBenes(bs, cond, low);
            cond_ptr += inc;
            --low;
        }
        BENES12.transpose_64x64(bs, bs);
        low = 5;
        while (low >= 0) {
            i = 0;
            while (i < 64) {
                cond[i] = Utils.load4(bits, cond_ptr + i * 4);
                ++i;
            }
            BENES12.transpose_64x64(cond, cond);
            BENES12.layerBenes(bs, cond, low);
            cond_ptr += inc;
            --low;
        }
        BENES12.transpose_64x64(bs, bs);
        i = 0;
        while (i < 64) {
            Utils.store8(r, i * 8, bs[i]);
            ++i;
        }
    }

    @Override
    public void support_gen(short[] s, byte[] c) {
        int j;
        byte[][] L = new byte[this.GFBITS][(1 << this.GFBITS) / 8];
        int i = 0;
        while (i < this.GFBITS) {
            j = 0;
            while (j < (1 << this.GFBITS) / 8) {
                L[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 1 << this.GFBITS) {
            short a = Utils.bitrev((short)i, this.GFBITS);
            j = 0;
            while (j < this.GFBITS) {
                byte[] byArray = L[j];
                int n = i / 8;
                byArray[n] = (byte)(byArray[n] | (a >> j & 1) << i % 8);
                ++j;
            }
            ++i;
        }
        int j2 = 0;
        while (j2 < this.GFBITS) {
            this.apply_benes(L[j2], c, 0);
            ++j2;
        }
        i = 0;
        while (i < this.SYS_N) {
            s[i] = 0;
            j = this.GFBITS - 1;
            while (j >= 0) {
                int n = i;
                s[n] = (short)(s[n] << 1);
                int n2 = i;
                s[n2] = (short)(s[n2] | L[j][i / 8] >> i % 8 & 1);
                --j;
            }
            ++i;
        }
    }
}

