/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.pqc.crypto.cmce.GF;

final class GF12
extends GF {
    GF12() {
    }

    @Override
    protected void gf_mul_poly(int length, int[] poly, short[] out, short[] left, short[] right, int[] temp) {
        temp[0] = this.gf_mul_ext(left[0], right[0]);
        int i = 1;
        while (i < length) {
            temp[i + i - 1] = 0;
            short left_i = left[i];
            short right_i = right[i];
            int j = 0;
            while (j < i) {
                int n = i + j;
                temp[n] = temp[n] ^ this.gf_mul_ext_par(left_i, right[j], left[j], right_i);
                ++j;
            }
            temp[i + i] = this.gf_mul_ext(left_i, right_i);
            ++i;
        }
        i = (length - 1) * 2;
        while (i >= length) {
            int temp_i = temp[i];
            int j = 0;
            while (j < poly.length - 1) {
                int n = i - length + poly[j];
                temp[n] = temp[n] ^ temp_i;
                ++j;
            }
            int n = i - length;
            temp[n] = temp[n] ^ temp_i << 1;
            --i;
        }
        i = 0;
        while (i < length) {
            out[i] = this.gf_reduce(temp[i]);
            ++i;
        }
    }

    @Override
    protected void gf_sqr_poly(int length, int[] poly, short[] out, short[] input, int[] temp) {
        temp[0] = this.gf_sq_ext(input[0]);
        int i = 1;
        while (i < length) {
            temp[i + i - 1] = 0;
            temp[i + i] = this.gf_sq_ext(input[i]);
            ++i;
        }
        i = (length - 1) * 2;
        while (i >= length) {
            int temp_i = temp[i];
            int j = 0;
            while (j < poly.length - 1) {
                int n = i - length + poly[j];
                temp[n] = temp[n] ^ temp_i;
                ++j;
            }
            int n = i - length;
            temp[n] = temp[n] ^ temp_i << 1;
            --i;
        }
        i = 0;
        while (i < length) {
            out[i] = this.gf_reduce(temp[i]);
            ++i;
        }
    }

    @Override
    protected short gf_frac(short den, short num) {
        return this.gf_mul(this.gf_inv(den), num);
    }

    @Override
    protected short gf_inv(short input) {
        short out = input;
        out = this.gf_sq(out);
        short tmp_11 = this.gf_mul(out, input);
        out = this.gf_sq(tmp_11);
        out = this.gf_sq(out);
        short tmp_1111 = this.gf_mul(out, tmp_11);
        out = this.gf_sq(tmp_1111);
        out = this.gf_sq(out);
        out = this.gf_sq(out);
        out = this.gf_sq(out);
        out = this.gf_mul(out, tmp_1111);
        out = this.gf_sq(out);
        out = this.gf_sq(out);
        out = this.gf_mul(out, tmp_11);
        out = this.gf_sq(out);
        out = this.gf_mul(out, input);
        return this.gf_sq(out);
    }

    @Override
    protected short gf_mul(short left, short right) {
        short x = left;
        short y = right;
        int z = x * (y & 1);
        int i = 1;
        while (i < 12) {
            z ^= x * (y & 1 << i);
            ++i;
        }
        return this.gf_reduce(z);
    }

    @Override
    protected int gf_mul_ext(short left, short right) {
        short x = left;
        short y = right;
        int z = x * (y & 1);
        int i = 1;
        while (i < 12) {
            z ^= x * (y & 1 << i);
            ++i;
        }
        return z;
    }

    private int gf_mul_ext_par(short left0, short right0, short left1, short right1) {
        short x0 = left0;
        short y0 = right0;
        short x1 = left1;
        short y1 = right1;
        int z0 = x0 * (y0 & 1);
        int z1 = x1 * (y1 & 1);
        int i = 1;
        while (i < 12) {
            z0 ^= x0 * (y0 & 1 << i);
            z1 ^= x1 * (y1 & 1 << i);
            ++i;
        }
        return z0 ^ z1;
    }

    @Override
    protected short gf_reduce(int x) {
        int u0 = x & 0xFFF;
        int u1 = x >>> 12;
        int u2 = (x & 0x1FF000) >>> 9;
        int u3 = (x & 0xE00000) >>> 18;
        int u4 = x >>> 21;
        return (short)(u0 ^ u1 ^ u2 ^ u3 ^ u4);
    }

    @Override
    protected short gf_sq(short input) {
        int z = Interleave.expand16to32(input);
        return this.gf_reduce(z);
    }

    @Override
    protected int gf_sq_ext(short input) {
        return Interleave.expand16to32(input);
    }
}

