/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.pqc.crypto.falcon.SHAKE256;

class FalconCommon {
    static final int[] l2bound;

    static {
        int[] nArray = new int[11];
        nArray[1] = 101498;
        nArray[2] = 208714;
        nArray[3] = 428865;
        nArray[4] = 892039;
        nArray[5] = 1852696;
        nArray[6] = 3842630;
        nArray[7] = 7959734;
        nArray[8] = 16468416;
        nArray[9] = 34034726;
        nArray[10] = 70265242;
        l2bound = nArray;
    }

    FalconCommon() {
    }

    void hash_to_point_vartime(SHAKE256 sc, short[] srcx, int x, int logn) {
        int n = 1 << logn;
        while (n > 0) {
            byte[] buf = new byte[2];
            sc.inner_shake256_extract(buf, 0, 2);
            int w = (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
            if (w >= 61445) continue;
            while (w >= 12289) {
                w -= 12289;
            }
            srcx[x++] = (short)w;
            --n;
        }
    }

    void hash_to_point_ct(SHAKE256 sc, short[] srcx, int x, int logn, short[] srctmp, int tmp) {
        short[] sArray = new short[11];
        sArray[1] = 65;
        sArray[2] = 67;
        sArray[3] = 71;
        sArray[4] = 77;
        sArray[5] = 86;
        sArray[6] = 100;
        sArray[7] = 122;
        sArray[8] = 154;
        sArray[9] = 205;
        sArray[10] = 287;
        short[] overtab = sArray;
        short[] tt2 = new short[63];
        int n = 1 << logn;
        int n2 = n << 1;
        int over = overtab[logn];
        int m = n + over;
        int tt1 = tmp;
        int u = 0;
        while (u < m) {
            byte[] buf = new byte[2];
            sc.inner_shake256_extract(buf, 0, buf.length);
            int w = (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
            int wr = w - (0x6002 & (w - 24578 >>> 31) - 1);
            wr -= 0x6002 & (wr - 24578 >>> 31) - 1;
            wr -= 0x3001 & (wr - 12289 >>> 31) - 1;
            wr |= (w - 61445 >>> 31) - 1;
            if (u < n) {
                srcx[x + u] = (short)wr;
            } else if (u < n2) {
                srctmp[tt1 + u - n] = (short)wr;
            } else {
                tt2[u - n2] = (short)wr;
            }
            ++u;
        }
        int p = 1;
        while (p <= over) {
            int v = 0;
            u = 0;
            while (u < m) {
                short sv;
                int s;
                int sp;
                if (u < n) {
                    sp = 1;
                    s = x + u;
                    sv = srcx[s];
                } else if (u < n2) {
                    sp = 2;
                    s = tt1 + u - n;
                    sv = srctmp[s];
                } else {
                    sp = 3;
                    s = u - n2;
                    sv = tt2[s];
                }
                int j = u - v;
                int mk = (sv >>> 15) - 1;
                v -= mk;
                if (u >= p) {
                    short dv;
                    int d;
                    int dp;
                    if (u - p < n) {
                        dp = 1;
                        d = x + u - p;
                        dv = srcx[d];
                    } else if (u - p < n2) {
                        dp = 2;
                        d = tt1 + (u - p) - n;
                        dv = srctmp[d];
                    } else {
                        dp = 3;
                        d = u - p - n2;
                        dv = tt2[d];
                    }
                    mk &= -((j & p) + 511 >> 9);
                    if (sp == 1) {
                        srcx[s] = (short)(sv ^ mk & (sv ^ dv));
                    } else if (sp == 2) {
                        srctmp[s] = (short)(sv ^ mk & (sv ^ dv));
                    } else {
                        tt2[s] = (short)(sv ^ mk & (sv ^ dv));
                    }
                    if (dp == 1) {
                        srcx[d] = (short)(dv ^ mk & (sv ^ dv));
                    } else if (dp == 2) {
                        srctmp[d] = (short)(dv ^ mk & (sv ^ dv));
                    } else {
                        tt2[d] = (short)(dv ^ mk & (sv ^ dv));
                    }
                }
                ++u;
            }
            p <<= 1;
        }
    }

    int is_short(short[] srcs1, int s1, short[] srcs2, int s2, int logn) {
        int n = 1 << logn;
        int s = 0;
        int ng = 0;
        int u = 0;
        while (u < n) {
            short z = srcs1[s1 + u];
            ng |= (s += z * z);
            z = srcs2[s2 + u];
            ng |= (s += z * z);
            ++u;
        }
        return ((long)(s |= -(ng >>> 31)) & 0xFFFFFFFFL) <= (long)l2bound[logn] ? 1 : 0;
    }

    int is_short_half(int sqn, short[] srcs2, int s2, int logn) {
        int n = 1 << logn;
        int ng = -(sqn >>> 31);
        int u = 0;
        while (u < n) {
            short z = srcs2[s2 + u];
            ng |= (sqn += z * z);
            ++u;
        }
        return ((long)(sqn |= -(ng >>> 31)) & 0xFFFFFFFFL) <= (long)l2bound[logn] ? 1 : 0;
    }
}

