/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import org.bouncycastle.pqc.crypto.rainbow.GF2Field;

class ComputeInField {
    public short[] solveEquation(short[][] B, short[] b) {
        if (B.length != b.length) {
            return null;
        }
        try {
            short[][] A = new short[B.length][B.length + 1];
            short[] x = new short[B.length];
            int i = 0;
            while (i < B.length) {
                System.arraycopy(B[i], 0, A[i], 0, B[0].length);
                A[i][b.length] = GF2Field.addElem(b[i], A[i][b.length]);
                ++i;
            }
            this.gaussElim(A);
            i = 0;
            while (i < A.length) {
                x[i] = A[i][b.length];
                ++i;
            }
            return x;
        }
        catch (RuntimeException rte) {
            return null;
        }
    }

    public short[][] inverse(short[][] coef) {
        if (coef.length != coef[0].length) {
            throw new RuntimeException("The matrix is not invertible. Please choose another one!");
        }
        try {
            int j;
            short[][] A = new short[coef.length][2 * coef.length];
            int i = 0;
            while (i < coef.length) {
                System.arraycopy(coef[i], 0, A[i], 0, coef.length);
                j = coef.length;
                while (j < 2 * coef.length) {
                    A[i][j] = 0;
                    ++j;
                }
                A[i][i + A.length] = 1;
                ++i;
            }
            this.gaussElim(A);
            short[][] inverse = new short[A.length][A.length];
            i = 0;
            while (i < A.length) {
                j = A.length;
                while (j < 2 * A.length) {
                    inverse[i][j - A.length] = A[i][j];
                    ++j;
                }
                ++i;
            }
            return inverse;
        }
        catch (RuntimeException rte) {
            return null;
        }
    }

    private void gaussElim(short[][] A) {
        int i = 0;
        while (i < A.length) {
            int k;
            int j = i + 1;
            while (j < A.length) {
                if (A[i][i] == 0) {
                    k = i;
                    while (k < A[0].length) {
                        A[i][k] = GF2Field.addElem(A[i][k], A[j][k]);
                        ++k;
                    }
                }
                ++j;
            }
            short factor = GF2Field.invElem(A[i][i]);
            if (factor == 0) {
                throw new RuntimeException("The matrix is not invertible");
            }
            A[i] = this.multVect(factor, A[i]);
            j = 0;
            while (j < A.length) {
                if (i != j) {
                    short factor2 = A[j][i];
                    k = i;
                    while (k < A[0].length) {
                        short tmp = GF2Field.multElem(A[i][k], factor2);
                        A[j][k] = GF2Field.addElem(A[j][k], tmp);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public short[][] multiplyMatrix(short[][] M1, short[][] M2) throws RuntimeException {
        if (M1[0].length != M2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short tmp = 0;
        short[][] A = new short[M1.length][M2[0].length];
        int i = 0;
        while (i < M1.length) {
            int j = 0;
            while (j < M2.length) {
                int k = 0;
                while (k < M2[0].length) {
                    tmp = GF2Field.multElem(M1[i][j], M2[j][k]);
                    A[i][k] = GF2Field.addElem(A[i][k], tmp);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return A;
    }

    public short[] multiplyMatrix(short[][] M1, short[] m) throws RuntimeException {
        if (M1[0].length != m.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short tmp = 0;
        short[] B = new short[M1.length];
        int i = 0;
        while (i < M1.length) {
            int j = 0;
            while (j < m.length) {
                tmp = GF2Field.multElem(M1[i][j], m[j]);
                B[i] = GF2Field.addElem(B[i], tmp);
                ++j;
            }
            ++i;
        }
        return B;
    }

    public short multiplyMatrix_quad(short[][] M1, short[] m) throws RuntimeException {
        if (M1.length != M1[0].length || M1[0].length != m.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short tmp = 0;
        short[] B = new short[M1.length];
        short ret = 0;
        int i = 0;
        while (i < M1.length) {
            int j = 0;
            while (j < m.length) {
                tmp = GF2Field.multElem(M1[i][j], m[j]);
                B[i] = GF2Field.addElem(B[i], tmp);
                ++j;
            }
            tmp = GF2Field.multElem(B[i], m[i]);
            ret = GF2Field.addElem(ret, tmp);
            ++i;
        }
        return ret;
    }

    public short[] addVect(short[] vector1, short[] vector2) {
        if (vector1.length != vector2.length) {
            throw new RuntimeException("Addition is not possible! vector1.length: " + vector1.length + " vector2.length: " + vector2.length);
        }
        short[] rslt = new short[vector1.length];
        int n = 0;
        while (n < rslt.length) {
            rslt[n] = GF2Field.addElem(vector1[n], vector2[n]);
            ++n;
        }
        return rslt;
    }

    public short[][] multVects(short[] vector1, short[] vector2) {
        if (vector1.length != vector2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[][] rslt = new short[vector1.length][vector2.length];
        int i = 0;
        while (i < vector1.length) {
            int j = 0;
            while (j < vector2.length) {
                rslt[i][j] = GF2Field.multElem(vector1[i], vector2[j]);
                ++j;
            }
            ++i;
        }
        return rslt;
    }

    public short[] multVect(short scalar, short[] vector) {
        short[] rslt = new short[vector.length];
        int n = 0;
        while (n < rslt.length) {
            rslt[n] = GF2Field.multElem(scalar, vector[n]);
            ++n;
        }
        return rslt;
    }

    public short[][] multMatrix(short scalar, short[][] matrix) {
        short[][] rslt = new short[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                rslt[i][j] = GF2Field.multElem(scalar, matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return rslt;
    }

    public short[][] addMatrix(short[][] matrix1, short[][] matrix2) {
        if (matrix1.length != matrix2.length || matrix1[0].length != matrix2[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        short[][] rslt = new short[matrix1.length][matrix1[0].length];
        int i = 0;
        while (i < matrix1.length) {
            int j = 0;
            while (j < matrix1[0].length) {
                rslt[i][j] = GF2Field.addElem(matrix1[i][j], matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        return rslt;
    }

    public short[][] addMatrixTranspose(short[][] matrix) {
        if (matrix.length != matrix[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        return this.addMatrix(matrix, this.transpose(matrix));
    }

    public short[][] transpose(short[][] matrix) {
        short[][] rslt = new short[matrix[0].length][matrix.length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                rslt[j][i] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return rslt;
    }

    public short[][] to_UT(short[][] matrix) {
        if (matrix.length != matrix[0].length) {
            throw new RuntimeException("Computation to upper triangular matrix is not possible!");
        }
        short[][] rslt = new short[matrix.length][matrix.length];
        int i = 0;
        while (i < matrix.length) {
            rslt[i][i] = matrix[i][i];
            int j = i + 1;
            while (j < matrix[0].length) {
                rslt[i][j] = GF2Field.addElem(matrix[i][j], matrix[j][i]);
                ++j;
            }
            ++i;
        }
        return rslt;
    }

    public short[][][] obfuscate_l1_polys(short[][] a, short[][][] b, short[][][] c) {
        if (b[0].length != c[0].length || b[0][0].length != c[0][0].length || b.length != a[0].length || c.length != a.length) {
            throw new RuntimeException("Multiplication not possible!");
        }
        short[][][] ret = new short[c.length][c[0].length][c[0][0].length];
        int i = 0;
        while (i < b[0].length) {
            int j = 0;
            while (j < b[0][0].length) {
                int l = 0;
                while (l < a.length) {
                    int k = 0;
                    while (k < a[0].length) {
                        short temp = GF2Field.multElem(a[l][k], b[k][i][j]);
                        ret[l][i][j] = GF2Field.addElem(ret[l][i][j], temp);
                        ++k;
                    }
                    ret[l][i][j] = GF2Field.addElem(c[l][i][j], ret[l][i][j]);
                    ++l;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

