/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.pqc.crypto.rainbow.RainbowUtil;
import org.bouncycastle.util.Arrays;

class RainbowDRBG
extends SecureRandom {
    private byte[] seed;
    private byte[] key;
    private byte[] v;
    private Digest hashAlgo;

    public RainbowDRBG(byte[] seed, Digest hashAlgo) {
        this.seed = seed;
        this.hashAlgo = hashAlgo;
        this.init(256);
    }

    private void init(int strength) {
        if (this.seed.length >= 48) {
            this.randombytes_init(this.seed, strength);
        } else {
            byte[] out = RainbowUtil.hash(this.hashAlgo, this.seed, 48 - this.seed.length);
            this.randombytes_init(Arrays.concatenate(this.seed, out), strength);
        }
    }

    @Override
    public void nextBytes(byte[] x) {
        byte[] block = new byte[16];
        int i = 0;
        int xlen = x.length;
        while (xlen > 0) {
            int j = 15;
            while (j >= 0) {
                if ((this.v[j] & 0xFF) != 255) {
                    int n = j;
                    this.v[n] = (byte)(this.v[n] + 1);
                    break;
                }
                this.v[j] = 0;
                --j;
            }
            this.AES256_ECB(this.key, this.v, block, 0);
            if (xlen > 15) {
                System.arraycopy(block, 0, x, i, block.length);
                i += 16;
                xlen -= 16;
                continue;
            }
            System.arraycopy(block, 0, x, i, xlen);
            xlen = 0;
        }
        this.AES256_CTR_DRBG_Update(null, this.key, this.v);
    }

    private void AES256_ECB(byte[] key, byte[] ctr, byte[] buffer, int startPosition) {
        try {
            AESEngine cipher = new AESEngine();
            cipher.init(true, new KeyParameter(key));
            int i = 0;
            while (i != ctr.length) {
                cipher.processBlock(ctr, i, buffer, startPosition + i);
                i += 16;
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("drbg failure: " + ex.getMessage(), ex);
        }
    }

    private void AES256_CTR_DRBG_Update(byte[] entropy_input, byte[] key, byte[] v) {
        byte[] tmp = new byte[48];
        int i = 0;
        while (i < 3) {
            int j = 15;
            while (j >= 0) {
                if ((v[j] & 0xFF) != 255) {
                    int n = j;
                    v[n] = (byte)(v[n] + 1);
                    break;
                }
                v[j] = 0;
                --j;
            }
            this.AES256_ECB(key, v, tmp, 16 * i);
            ++i;
        }
        if (entropy_input != null) {
            i = 0;
            while (i < 48) {
                int n = i;
                tmp[n] = (byte)(tmp[n] ^ entropy_input[i]);
                ++i;
            }
        }
        System.arraycopy(tmp, 0, key, 0, key.length);
        System.arraycopy(tmp, 32, v, 0, v.length);
    }

    private void randombytes_init(byte[] entropyInput, int strength) {
        byte[] seedMaterial = new byte[48];
        System.arraycopy(entropyInput, 0, seedMaterial, 0, seedMaterial.length);
        this.key = new byte[32];
        this.v = new byte[16];
        this.AES256_CTR_DRBG_Update(seedMaterial, this.key, this.v);
    }
}

