/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import org.bouncycastle.pqc.crypto.rainbow.ComputeInField;
import org.bouncycastle.pqc.crypto.rainbow.GF2Field;
import org.bouncycastle.pqc.crypto.rainbow.RainbowDRBG;
import org.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowUtil;
import org.bouncycastle.util.Arrays;

class RainbowPublicMap {
    private ComputeInField cf = new ComputeInField();
    private RainbowParameters params;
    private final int num_gf_elements = 256;

    public RainbowPublicMap(RainbowParameters params) {
        this.params = params;
    }

    private short[][] compute_accumulator(short[] x, short[] y, short[][][] a, int dim) {
        short[][] accu = new short[256][dim];
        if (y.length != a[0].length || x.length != a[0][0].length || a.length != dim) {
            throw new RuntimeException("Accumulator calculation not possible!");
        }
        int i = 0;
        while (i < y.length) {
            short[] tmp = this.cf.multVect(y[i], x);
            int j = 0;
            while (j < x.length) {
                int k = 0;
                while (k < a.length) {
                    short index = tmp[j];
                    if (index != 0) {
                        accu[index][k] = GF2Field.addElem(accu[index][k], a[k][i][j]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return accu;
    }

    private short[] add_and_reduce(short[][] accu) {
        int m = this.params.getM();
        short[] ret = new short[m];
        int b = 0;
        while (b < 8) {
            int accu_bit = (int)Math.pow(2.0, b);
            short[] tmp = new short[m];
            int i = accu_bit;
            while (i < 256) {
                int j = 0;
                while (j < accu_bit) {
                    tmp = this.cf.addVect(tmp, accu[i + j]);
                    ++j;
                }
                i += accu_bit * 2;
            }
            ret = this.cf.addVect(ret, this.cf.multVect((short)accu_bit, tmp));
            ++b;
        }
        return ret;
    }

    public short[] publicMap(RainbowPublicKeyParameters pk, short[] signature) {
        short[][] accu = this.compute_accumulator(signature, signature, pk.pk, this.params.getM());
        return this.add_and_reduce(accu);
    }

    public short[] publicMap_cyclic(RainbowPublicKeyParameters pk, short[] signature) {
        int v1 = this.params.getV1();
        int o1 = this.params.getO1();
        int o2 = this.params.getO2();
        short[][] accu = new short[256][o1 + o2];
        short[] sig_v1 = Arrays.copyOfRange(signature, 0, v1);
        short[] sig_o1 = Arrays.copyOfRange(signature, v1, v1 + o1);
        short[] sig_o2 = Arrays.copyOfRange(signature, v1 + o1, signature.length);
        RainbowDRBG pk_random = new RainbowDRBG(pk.pk_seed, pk.getParameters().getHash_algo());
        short[][][] tmp = RainbowUtil.generate_random(pk_random, o1, v1, v1, true);
        short[][] accu_l1 = this.compute_accumulator(sig_v1, sig_v1, tmp, o1);
        tmp = RainbowUtil.generate_random(pk_random, o1, v1, o1, false);
        accu_l1 = this.cf.addMatrix(accu_l1, this.compute_accumulator(sig_o1, sig_v1, tmp, o1));
        accu_l1 = this.cf.addMatrix(accu_l1, this.compute_accumulator(sig_o2, sig_v1, pk.l1_Q3, o1));
        accu_l1 = this.cf.addMatrix(accu_l1, this.compute_accumulator(sig_o1, sig_o1, pk.l1_Q5, o1));
        accu_l1 = this.cf.addMatrix(accu_l1, this.compute_accumulator(sig_o2, sig_o1, pk.l1_Q6, o1));
        accu_l1 = this.cf.addMatrix(accu_l1, this.compute_accumulator(sig_o2, sig_o2, pk.l1_Q9, o1));
        tmp = RainbowUtil.generate_random(pk_random, o2, v1, v1, true);
        short[][] accu_l2 = this.compute_accumulator(sig_v1, sig_v1, tmp, o2);
        tmp = RainbowUtil.generate_random(pk_random, o2, v1, o1, false);
        accu_l2 = this.cf.addMatrix(accu_l2, this.compute_accumulator(sig_o1, sig_v1, tmp, o2));
        tmp = RainbowUtil.generate_random(pk_random, o2, v1, o2, false);
        accu_l2 = this.cf.addMatrix(accu_l2, this.compute_accumulator(sig_o2, sig_v1, tmp, o2));
        tmp = RainbowUtil.generate_random(pk_random, o2, o1, o1, true);
        accu_l2 = this.cf.addMatrix(accu_l2, this.compute_accumulator(sig_o1, sig_o1, tmp, o2));
        tmp = RainbowUtil.generate_random(pk_random, o2, o1, o2, false);
        accu_l2 = this.cf.addMatrix(accu_l2, this.compute_accumulator(sig_o2, sig_o1, tmp, o2));
        accu_l2 = this.cf.addMatrix(accu_l2, this.compute_accumulator(sig_o2, sig_o2, pk.l2_Q9, o2));
        int i = 0;
        while (i < 256) {
            accu[i] = Arrays.concatenate(accu_l1[i], accu_l2[i]);
            ++i;
        }
        return this.add_and_reduce(accu);
    }
}

