/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.gmss.util;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.legacy.crypto.gmss.util.GMSSRandom;

public class WinternitzOTSignature {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[][] privateKeyOTS;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int checksumsize;

    public WinternitzOTSignature(byte[] seed0, Digest digest, int w) {
        this.w = w;
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        this.messagesize = ((this.mdsize << 3) + w - 1) / w;
        this.checksumsize = this.getLog((this.messagesize << w) + 1);
        this.keysize = this.messagesize + (this.checksumsize + w - 1) / w;
        this.privateKeyOTS = new byte[this.keysize][];
        byte[] dummy = new byte[this.mdsize];
        System.arraycopy(seed0, 0, dummy, 0, dummy.length);
        int i = 0;
        while (i < this.keysize) {
            this.privateKeyOTS[i] = this.gmssRandom.nextSeed(dummy);
            ++i;
        }
    }

    public byte[][] getPrivateKey() {
        return this.privateKeyOTS;
    }

    public byte[] getPublicKey() {
        byte[] buf = new byte[this.keysize * this.mdsize];
        int pos = 0;
        int rounds = (1 << this.w) - 1;
        int i = 0;
        while (i < this.keysize) {
            this.hashPrivateKeyBlock(i, rounds, buf, pos);
            pos += this.mdsize;
            ++i;
        }
        this.messDigestOTS.update(buf, 0, buf.length);
        byte[] tmp = new byte[this.mdsize];
        this.messDigestOTS.doFinal(tmp, 0);
        return tmp;
    }

    public byte[] getSignature(byte[] message) {
        byte[] sign;
        block18: {
            long test8;
            int j;
            int ii;
            long big8;
            int rest;
            int s;
            int c;
            int counter;
            byte[] hash;
            block19: {
                long big82;
                int test;
                block17: {
                    sign = new byte[this.keysize * this.mdsize];
                    hash = new byte[this.mdsize];
                    counter = 0;
                    c = 0;
                    test = 0;
                    this.messDigestOTS.update(message, 0, message.length);
                    this.messDigestOTS.doFinal(hash, 0);
                    if (8 % this.w != 0) break block17;
                    int d = 8 / this.w;
                    int k = (1 << this.w) - 1;
                    int i = 0;
                    while (i < hash.length) {
                        int j2 = 0;
                        while (j2 < d) {
                            test = hash[i] & k;
                            c += test;
                            this.hashPrivateKeyBlock(counter, test, sign, counter * this.mdsize);
                            hash[i] = (byte)(hash[i] >>> this.w);
                            ++counter;
                            ++j2;
                        }
                        ++i;
                    }
                    c = (this.messagesize << this.w) - c;
                    i = 0;
                    while (i < this.checksumsize) {
                        test = c & k;
                        this.hashPrivateKeyBlock(counter, test, sign, counter * this.mdsize);
                        c >>>= this.w;
                        ++counter;
                        i += this.w;
                    }
                    break block18;
                }
                if (this.w >= 8) break block19;
                int d = this.mdsize / this.w;
                int k = (1 << this.w) - 1;
                int ii2 = 0;
                int i = 0;
                while (i < d) {
                    big82 = 0L;
                    int j3 = 0;
                    while (j3 < this.w) {
                        big82 ^= (long)((hash[ii2] & 0xFF) << (j3 << 3));
                        ++ii2;
                        ++j3;
                    }
                    j3 = 0;
                    while (j3 < 8) {
                        test = (int)big82 & k;
                        c += test;
                        this.hashPrivateKeyBlock(counter, test, sign, counter * this.mdsize);
                        big82 >>>= this.w;
                        ++counter;
                        ++j3;
                    }
                    ++i;
                }
                d = this.mdsize % this.w;
                big82 = 0L;
                int j4 = 0;
                while (j4 < d) {
                    big82 ^= (long)((hash[ii2] & 0xFF) << (j4 << 3));
                    ++ii2;
                    ++j4;
                }
                d <<= 3;
                j4 = 0;
                while (j4 < d) {
                    test = (int)big82 & k;
                    c += test;
                    this.hashPrivateKeyBlock(counter, test, sign, counter * this.mdsize);
                    big82 >>>= this.w;
                    ++counter;
                    j4 += this.w;
                }
                c = (this.messagesize << this.w) - c;
                i = 0;
                while (i < this.checksumsize) {
                    test = c & k;
                    this.hashPrivateKeyBlock(counter, test, sign, counter * this.mdsize);
                    c >>>= this.w;
                    ++counter;
                    i += this.w;
                }
                break block18;
            }
            if (this.w >= 57) break block18;
            int d = (this.mdsize << 3) - this.w;
            int k = (1 << this.w) - 1;
            byte[] hlp = new byte[this.mdsize];
            int r = 0;
            while (r <= d) {
                s = r >>> 3;
                rest = r % 8;
                int f = (r += this.w) + 7 >>> 3;
                big8 = 0L;
                ii = 0;
                j = s;
                while (j < f) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                    ++j;
                }
                test8 = (big8 >>>= rest) & (long)k;
                c = (int)((long)c + test8);
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                while (test8 > 0L) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    this.messDigestOTS.doFinal(hlp, 0);
                    --test8;
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                ++counter;
            }
            s = r >>> 3;
            if (s < this.mdsize) {
                rest = r % 8;
                big8 = 0L;
                ii = 0;
                j = s;
                while (j < this.mdsize) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                    ++j;
                }
                test8 = (big8 >>>= rest) & (long)k;
                c = (int)((long)c + test8);
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                while (test8 > 0L) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    this.messDigestOTS.doFinal(hlp, 0);
                    --test8;
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                ++counter;
            }
            c = (this.messagesize << this.w) - c;
            int i = 0;
            while (i < this.checksumsize) {
                test8 = c & k;
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                while (test8 > 0L) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    this.messDigestOTS.doFinal(hlp, 0);
                    --test8;
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                c >>>= this.w;
                ++counter;
                i += this.w;
            }
        }
        return sign;
    }

    public int getLog(int intValue) {
        int log = 1;
        int i = 2;
        while (i < intValue) {
            i <<= 1;
            ++log;
        }
        return log;
    }

    private void hashPrivateKeyBlock(int index, int rounds, byte[] buf, int off) {
        if (rounds < 1) {
            System.arraycopy(this.privateKeyOTS[index], 0, buf, off, this.mdsize);
        } else {
            this.messDigestOTS.update(this.privateKeyOTS[index], 0, this.mdsize);
            this.messDigestOTS.doFinal(buf, off);
            while (--rounds > 0) {
                this.messDigestOTS.update(buf, off, this.mdsize);
                this.messDigestOTS.doFinal(buf, off);
            }
        }
    }
}

