/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public class SmudgedBytes {
    private byte fudgeFactor;
    private byte[] contents;
    private static Random generator;
    private String provider = null;
    private static Debug debug;
    private static String className;

    public SmudgedBytes(byte[] input) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SmudgedBytes", (Object)input);
        }
        byte[] tempBytes = new byte[1];
        do {
            generator.nextBytes(tempBytes);
            this.fudgeFactor = tempBytes[0];
        } while (this.fudgeFactor == 0);
        this.contents = new byte[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            this.contents[i2] = (byte)(input[i2] + this.fudgeFactor);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SmudgedBytes");
        }
    }

    public SmudgedBytes(byte[] input, String provider) {
        byte[] tempBytes = new byte[1];
        if (debug != null) {
            debug.entry(16384L, className, "SmudgedBytes", input, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        do {
            generator.nextBytes(tempBytes);
            this.fudgeFactor = tempBytes[0];
        } while (this.fudgeFactor == 0);
        this.contents = new byte[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            this.contents[i2] = (byte)(input[i2] + this.fudgeFactor);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SmudgedBytes");
        }
    }

    public byte[] getClearText() {
        byte[] output = new byte[this.contents.length];
        if (debug != null) {
            debug.entry(16384L, className, "getClearText");
        }
        for (int i2 = 0; i2 < this.contents.length; ++i2) {
            output[i2] = (byte)(this.contents[i2] - this.fudgeFactor);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getClearText", output);
        }
        return output;
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, className, "finalize");
        }
        if (this.contents != null) {
            Arrays.fill(this.contents, (byte)0);
            this.contents = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "finalize");
        }
    }

    static {
        debug = Debug.getInstance("ibmpkcs");
        className = "com.ibm.security.pkcsutil.SmudgedBytes";
        generator = new Random(new Date().getTime());
    }
}

