/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.smime.jmail.PKCS7MimeDataSource;
import com.ibm.security.smime.jmail.PKCS7NewMimeDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class SMIMEMimeMultipart
extends MimeMultipart {
    private ContentInfo contentInfo;
    private String provider = null;
    private boolean oldTypes = true;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.SMIMEMimeMultipart";

    public SMIMEMimeMultipart() {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMimeMultipart");
            debug.exit(16384L, className, "SMIMEMimeMultipart");
        }
        this.contentInfo = null;
    }

    public SMIMEMimeMultipart(DataSource ds) throws MessagingException {
        super(ds);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMimeMultipart", ds);
        }
        if (ds instanceof PKCS7MimeDataSource) {
            PKCS7MimeDataSource pkcs7ds = (PKCS7MimeDataSource)ds;
            this.contentInfo = pkcs7ds.getContentInfo();
            this.oldTypes = true;
        } else if (ds instanceof PKCS7NewMimeDataSource) {
            PKCS7NewMimeDataSource pkcs7ds = (PKCS7NewMimeDataSource)ds;
            this.contentInfo = pkcs7ds.getContentInfo();
            this.oldTypes = false;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "SMIMEMimeMultipart", "DataSource must be an instance of PKCS7MimeDataSource.  Instead ds is an instance of " + ds.getClass().getName());
            }
            throw new IllegalArgumentException("DataSource must be an instance of PKCS7MimeDataSource.  Instead ds is an instance of " + ds.getClass().getName());
        }
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMultipart");
        }
    }

    public SMIMEMimeMultipart(DataSource ds, String provider) throws MessagingException {
        super(ds);
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMimeMultipart", ds, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (ds instanceof PKCS7MimeDataSource) {
            PKCS7MimeDataSource pkcs7ds = (PKCS7MimeDataSource)ds;
            this.contentInfo = pkcs7ds.getContentInfo();
            this.oldTypes = true;
        } else if (ds instanceof PKCS7NewMimeDataSource) {
            PKCS7NewMimeDataSource pkcs7ds = (PKCS7NewMimeDataSource)ds;
            this.contentInfo = pkcs7ds.getContentInfo();
            this.oldTypes = false;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "SMIMEMimeMultipart", "DataSource must be an instance of PKCS7MimeDataSource.  Instead ds is an instance of " + ds.getClass().getName());
            }
            throw new IllegalArgumentException("DataSource must be an instance of PKCS7MimeDataSource.  Instead ds is an instance of " + ds.getClass().getName());
        }
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMultipart");
        }
    }

    public SMIMEMimeMultipart(String subtype) {
        super(subtype);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMimeMultipart", subtype);
            debug.exit(16384L, className, "SMIMEMimeMultipart");
        }
        this.contentInfo = null;
    }

    public SMIMEMimeMultipart(String subtype, String provider) {
        super(subtype);
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMimeMultipart", subtype, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.contentInfo = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMultipart");
        }
    }

    public void setProvider(String provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setProvider", provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (debug != null) {
            debug.exit(16384L, className, "setProvider");
        }
    }

    public void setSMIMEContentType(boolean old) {
        this.oldTypes = old;
    }

    public boolean getSMIMEContentType() {
        return this.oldTypes;
    }

    public void signSignatureOnly(Object message, Certificate signerCert, PrivateKey privateKey, String digestSignatureAlgorithm) throws PKCSException, IOException, NoSuchAlgorithmException, MessagingException {
        if (debug != null) {
            Object[] parms = new Object[]{message, signerCert, privateKey, digestSignatureAlgorithm};
            debug.entry(16384L, (Object)className, "signSignatureOnly", parms);
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "ContentInfo must not be specified.");
            }
            throw new PKCSException("ContentInfo must not be specified.");
        }
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "Message must be specified.");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "digestSignatureAlgorithm must be specified.");
            }
            throw new IllegalArgumentException("digestSignatureAlgorithm must be specified.");
        }
        MimeBodyPart part1 = new MimeBodyPart();
        if (message instanceof String) {
            part1.setContent(message, "text/plain");
        } else if (message instanceof Multipart) {
            part1.setContent((Multipart)message);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "message must be an instance of String or Multipart.  Instead message is an instance of " + message.getClass().getName());
            }
            throw new IllegalArgumentException("message must be an instance of String or Multipart.  Instead message is an instance of " + message.getClass().getName());
        }
        this.addBodyPart(part1);
        this.updateHeaders();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        part1.writeTo(baos);
        byte[] contentBytes = baos.toByteArray();
        baos.close();
        Data data = new Data(this.provider);
        data.setData(contentBytes);
        ContentInfo ci = new ContentInfo(data, this.provider);
        boolean signatureOnly = false;
        SignedData sd = new SignedData(signerCert, ci, digestSignatureAlgorithm, privateKey, signatureOnly, this.provider);
        sd.removeContent();
        ContentInfo cisd = new ContentInfo(sd, this.provider);
        MimeBodyPart part2 = new MimeBodyPart();
        String contentType = null;
        contentType = this.oldTypes ? "application/x-pkcs7-signature; name=\"" : "application/pkcs7-signature; name=\"";
        contentType = contentType + "smime.p7s\"";
        String disposition = "attachment; filename=\"smime.p7s\"";
        String description = "S/MIME Cryptographic Signature";
        part2.setContent(cisd, contentType);
        part2.setDisposition(disposition);
        part2.setDescription(description);
        this.addBodyPart(part2);
        String digestAlgorithm = PKCS7.getDigestAlgorithm(digestSignatureAlgorithm);
        String micalg = this.getmicalg(digestAlgorithm);
        String subtype = null;
        subtype = this.oldTypes ? "signed; protocol=\"application/x-pkcs7-signature\"; micalg=" + micalg : "signed; protocol=\"application/pkcs7-signature\"; micalg=" + micalg;
        this.setSubType(subtype);
        this.updateHeaders();
        if (debug != null) {
            debug.exit(16384L, className, "signSignatureOnly");
        }
    }

    private String getmicalg(String digestAlgorithm) {
        String micalg = digestAlgorithm;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getmicalg", digestAlgorithm);
        }
        if (micalg.equalsIgnoreCase("md5")) {
            micalg = "md5";
        } else if (micalg.equalsIgnoreCase("sha") || micalg.equalsIgnoreCase("sha1") || micalg.equalsIgnoreCase("sha-1")) {
            micalg = "sha1";
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getmicalg", micalg);
        }
        return micalg;
    }

    public String toString() {
        String out = "SMIMEMimeMultipart:  ";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = this.contentInfo != null ? out + this.contentInfo.toString() : out + "Does not contain a ContentInfo object.";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }
}

