/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.GlyphList;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfEncodings;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;

public class DocumentFont
extends BaseFont {
    private HashMap<Integer, int[]> metrics = new HashMap();
    private String fontName;
    private PRIndirectReference refFont;
    private PdfDictionary font;
    private IntHashtable uni2byte = new IntHashtable();
    private IntHashtable diffmap;
    private float Ascender = 800.0f;
    private float CapHeight = 700.0f;
    private float Descender = -200.0f;
    private float ItalicAngle = 0.0f;
    private float llx = -50.0f;
    private float lly = -200.0f;
    private float urx = 100.0f;
    private float ury = 900.0f;
    private boolean isType0 = false;
    private BaseFont cjkMirror;
    private static String[] cjkNames = new String[]{"HeiseiMin-W3", "HeiseiKakuGo-W5", "STSong-Light", "MHei-Medium", "MSung-Light", "HYGoThic-Medium", "HYSMyeongJo-Medium", "MSungStd-Light", "STSongStd-Light", "HYSMyeongJoStd-Medium", "KozMinPro-Regular"};
    private static String[] cjkEncs = new String[]{"UniJIS-UCS2-H", "UniJIS-UCS2-H", "UniGB-UCS2-H", "UniCNS-UCS2-H", "UniCNS-UCS2-H", "UniKS-UCS2-H", "UniKS-UCS2-H", "UniCNS-UCS2-H", "UniGB-UCS2-H", "UniKS-UCS2-H", "UniJIS-UCS2-H"};
    private static String[] cjkNames2 = new String[]{"MSungStd-Light", "STSongStd-Light", "HYSMyeongJoStd-Medium", "KozMinPro-Regular"};
    private static String[] cjkEncs2 = new String[]{"UniCNS-UCS2-H", "UniGB-UCS2-H", "UniKS-UCS2-H", "UniJIS-UCS2-H", "UniCNS-UTF16-H", "UniGB-UTF16-H", "UniKS-UTF16-H", "UniJIS-UTF16-H"};
    private static final int[] stdEnc;

    static {
        int[] nArray = new int[256];
        nArray[32] = 32;
        nArray[33] = 33;
        nArray[34] = 34;
        nArray[35] = 35;
        nArray[36] = 36;
        nArray[37] = 37;
        nArray[38] = 38;
        nArray[39] = 8217;
        nArray[40] = 40;
        nArray[41] = 41;
        nArray[42] = 42;
        nArray[43] = 43;
        nArray[44] = 44;
        nArray[45] = 45;
        nArray[46] = 46;
        nArray[47] = 47;
        nArray[48] = 48;
        nArray[49] = 49;
        nArray[50] = 50;
        nArray[51] = 51;
        nArray[52] = 52;
        nArray[53] = 53;
        nArray[54] = 54;
        nArray[55] = 55;
        nArray[56] = 56;
        nArray[57] = 57;
        nArray[58] = 58;
        nArray[59] = 59;
        nArray[60] = 60;
        nArray[61] = 61;
        nArray[62] = 62;
        nArray[63] = 63;
        nArray[64] = 64;
        nArray[65] = 65;
        nArray[66] = 66;
        nArray[67] = 67;
        nArray[68] = 68;
        nArray[69] = 69;
        nArray[70] = 70;
        nArray[71] = 71;
        nArray[72] = 72;
        nArray[73] = 73;
        nArray[74] = 74;
        nArray[75] = 75;
        nArray[76] = 76;
        nArray[77] = 77;
        nArray[78] = 78;
        nArray[79] = 79;
        nArray[80] = 80;
        nArray[81] = 81;
        nArray[82] = 82;
        nArray[83] = 83;
        nArray[84] = 84;
        nArray[85] = 85;
        nArray[86] = 86;
        nArray[87] = 87;
        nArray[88] = 88;
        nArray[89] = 89;
        nArray[90] = 90;
        nArray[91] = 91;
        nArray[92] = 92;
        nArray[93] = 93;
        nArray[94] = 94;
        nArray[95] = 95;
        nArray[96] = 8216;
        nArray[97] = 97;
        nArray[98] = 98;
        nArray[99] = 99;
        nArray[100] = 100;
        nArray[101] = 101;
        nArray[102] = 102;
        nArray[103] = 103;
        nArray[104] = 104;
        nArray[105] = 105;
        nArray[106] = 106;
        nArray[107] = 107;
        nArray[108] = 108;
        nArray[109] = 109;
        nArray[110] = 110;
        nArray[111] = 111;
        nArray[112] = 112;
        nArray[113] = 113;
        nArray[114] = 114;
        nArray[115] = 115;
        nArray[116] = 116;
        nArray[117] = 117;
        nArray[118] = 118;
        nArray[119] = 119;
        nArray[120] = 120;
        nArray[121] = 121;
        nArray[122] = 122;
        nArray[123] = 123;
        nArray[124] = 124;
        nArray[125] = 125;
        nArray[126] = 126;
        nArray[161] = 161;
        nArray[162] = 162;
        nArray[163] = 163;
        nArray[164] = 8260;
        nArray[165] = 165;
        nArray[166] = 402;
        nArray[167] = 167;
        nArray[168] = 164;
        nArray[169] = 39;
        nArray[170] = 8220;
        nArray[171] = 171;
        nArray[172] = 8249;
        nArray[173] = 8250;
        nArray[174] = 64257;
        nArray[175] = 64258;
        nArray[177] = 8211;
        nArray[178] = 8224;
        nArray[179] = 8225;
        nArray[180] = 183;
        nArray[182] = 182;
        nArray[183] = 8226;
        nArray[184] = 8218;
        nArray[185] = 8222;
        nArray[186] = 8221;
        nArray[187] = 187;
        nArray[188] = 8230;
        nArray[189] = 8240;
        nArray[191] = 191;
        nArray[193] = 96;
        nArray[194] = 180;
        nArray[195] = 710;
        nArray[196] = 732;
        nArray[197] = 175;
        nArray[198] = 728;
        nArray[199] = 729;
        nArray[200] = 168;
        nArray[202] = 730;
        nArray[203] = 184;
        nArray[205] = 733;
        nArray[206] = 731;
        nArray[207] = 711;
        nArray[208] = 8212;
        nArray[225] = 198;
        nArray[227] = 170;
        nArray[232] = 321;
        nArray[233] = 216;
        nArray[234] = 338;
        nArray[235] = 186;
        nArray[241] = 230;
        nArray[245] = 305;
        nArray[248] = 322;
        nArray[249] = 248;
        nArray[250] = 339;
        nArray[251] = 223;
        stdEnc = nArray;
    }

    DocumentFont(PRIndirectReference refFont) {
        this.encoding = "";
        this.fontSpecific = false;
        this.refFont = refFont;
        this.fontType = 4;
        this.font = (PdfDictionary)PdfReader.getPdfObject(refFont);
        this.fontName = PdfName.decodeName(this.font.getAsName(PdfName.BASEFONT).toString());
        PdfName subType = this.font.getAsName(PdfName.SUBTYPE);
        if (PdfName.TYPE1.equals(subType) || PdfName.TRUETYPE.equals(subType)) {
            this.doType1TT();
        } else {
            int k2 = 0;
            while (k2 < cjkNames.length) {
                if (this.fontName.startsWith(cjkNames[k2])) {
                    this.fontName = cjkNames[k2];
                    try {
                        this.cjkMirror = BaseFont.createFont(this.fontName, cjkEncs[k2], false);
                    }
                    catch (Exception e2) {
                        throw new ExceptionConverter(e2);
                    }
                    return;
                }
                ++k2;
            }
            String enc = PdfName.decodeName(this.font.getAsName(PdfName.ENCODING).toString());
            int k3 = 0;
            while (k3 < cjkEncs2.length) {
                if (enc.startsWith(cjkEncs2[k3])) {
                    try {
                        if (k3 > 3) {
                            k3 -= 4;
                        }
                        this.cjkMirror = BaseFont.createFont(cjkNames2[k3], cjkEncs2[k3], false);
                    }
                    catch (Exception e3) {
                        throw new ExceptionConverter(e3);
                    }
                    return;
                }
                ++k3;
            }
            if (PdfName.TYPE0.equals(subType) && enc.equals("Identity-H")) {
                this.processType0(this.font);
                this.isType0 = true;
            }
        }
    }

    private void processType0(PdfDictionary font) {
        try {
            PdfObject toUniObject = PdfReader.getPdfObjectRelease(font.get(PdfName.TOUNICODE));
            PdfArray df = (PdfArray)PdfReader.getPdfObjectRelease(font.get(PdfName.DESCENDANTFONTS));
            PdfDictionary cidft = (PdfDictionary)PdfReader.getPdfObjectRelease(df.getPdfObject(0));
            PdfNumber dwo = (PdfNumber)PdfReader.getPdfObjectRelease(cidft.get(PdfName.DW));
            int dw = 1000;
            if (dwo != null) {
                dw = dwo.intValue();
            }
            IntHashtable widths = this.readWidths((PdfArray)PdfReader.getPdfObjectRelease(cidft.get(PdfName.W)));
            PdfDictionary fontDesc = (PdfDictionary)PdfReader.getPdfObjectRelease(cidft.get(PdfName.FONTDESCRIPTOR));
            this.fillFontDesc(fontDesc);
            if (toUniObject != null) {
                this.fillMetrics(PdfReader.getStreamBytes((PRStream)toUniObject), widths, dw);
            }
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    private IntHashtable readWidths(PdfArray ws) {
        IntHashtable hh = new IntHashtable();
        if (ws == null) {
            return hh;
        }
        int k2 = 0;
        while (k2 < ws.size()) {
            PdfObject obj;
            int c1 = ((PdfNumber)PdfReader.getPdfObjectRelease(ws.getPdfObject(k2))).intValue();
            if ((obj = PdfReader.getPdfObjectRelease(ws.getPdfObject(++k2))).isArray()) {
                PdfArray a2 = (PdfArray)obj;
                int j2 = 0;
                while (j2 < a2.size()) {
                    int c2 = ((PdfNumber)PdfReader.getPdfObjectRelease(a2.getPdfObject(j2))).intValue();
                    hh.put(c1++, c2);
                    ++j2;
                }
            } else {
                int c2 = ((PdfNumber)obj).intValue();
                int w2 = ((PdfNumber)PdfReader.getPdfObjectRelease(ws.getPdfObject(++k2))).intValue();
                while (c1 <= c2) {
                    hh.put(c1, w2);
                    ++c1;
                }
            }
            ++k2;
        }
        return hh;
    }

    private String decodeString(PdfString ps) {
        if (ps.isHexWriting()) {
            return PdfEncodings.convertToString(ps.getBytes(), "UnicodeBigUnmarked");
        }
        return ps.toUnicodeString();
    }

    private void fillMetrics(byte[] touni, IntHashtable widths, int dw) {
        try {
            PdfContentParser ps = new PdfContentParser(new PRTokeniser(touni));
            PdfObject ob = null;
            PdfObject last = null;
            while ((ob = ps.readPRObject()) != null) {
                if (ob.type() == 200) {
                    int k2;
                    int n2;
                    if (ob.toString().equals("beginbfchar")) {
                        n2 = ((PdfNumber)last).intValue();
                        k2 = 0;
                        while (k2 < n2) {
                            String cid = this.decodeString((PdfString)ps.readPRObject());
                            String uni = this.decodeString((PdfString)ps.readPRObject());
                            if (uni.length() == 1) {
                                char cidc = cid.charAt(0);
                                char unic = uni.charAt(uni.length() - 1);
                                int w2 = dw;
                                if (widths.containsKey(cidc)) {
                                    w2 = widths.get(cidc);
                                }
                                this.metrics.put(new Integer(unic), new int[]{cidc, w2});
                            }
                            ++k2;
                        }
                        continue;
                    }
                    if (!ob.toString().equals("beginbfrange")) continue;
                    n2 = ((PdfNumber)last).intValue();
                    k2 = 0;
                    while (k2 < n2) {
                        String cid1 = this.decodeString((PdfString)ps.readPRObject());
                        String cid2 = this.decodeString((PdfString)ps.readPRObject());
                        int cid1c = cid1.charAt(0);
                        char cid2c = cid2.charAt(0);
                        PdfObject ob2 = ps.readPRObject();
                        if (ob2.isString()) {
                            String uni = this.decodeString((PdfString)ob2);
                            if (uni.length() == 1) {
                                int unic = uni.charAt(uni.length() - 1);
                                while (cid1c <= cid2c) {
                                    int w3 = dw;
                                    if (widths.containsKey(cid1c)) {
                                        w3 = widths.get(cid1c);
                                    }
                                    this.metrics.put(new Integer(unic), new int[]{cid1c++, w3});
                                    ++unic;
                                }
                            }
                        } else {
                            PdfArray a2 = (PdfArray)ob2;
                            int j2 = 0;
                            while (j2 < a2.size()) {
                                String uni = this.decodeString(a2.getAsString(j2));
                                if (uni.length() == 1) {
                                    char unic = uni.charAt(uni.length() - 1);
                                    int w4 = dw;
                                    if (widths.containsKey(cid1c)) {
                                        w4 = widths.get(cid1c);
                                    }
                                    this.metrics.put(new Integer(unic), new int[]{cid1c, w4});
                                }
                                ++j2;
                                ++cid1c;
                            }
                        }
                        ++k2;
                    }
                    continue;
                }
                last = ob;
            }
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    private void doType1TT() {
        PdfObject enc = PdfReader.getPdfObject(this.font.get(PdfName.ENCODING));
        if (enc == null) {
            this.fillEncoding(null);
        } else if (enc.isName()) {
            this.fillEncoding((PdfName)enc);
        } else {
            PdfDictionary encDic = (PdfDictionary)enc;
            if ((enc = PdfReader.getPdfObject(encDic.get(PdfName.BASEENCODING))) == null) {
                this.fillEncoding(null);
            } else {
                this.fillEncoding((PdfName)enc);
            }
            PdfArray diffs = encDic.getAsArray(PdfName.DIFFERENCES);
            if (diffs != null) {
                this.diffmap = new IntHashtable();
                int currentNumber = 0;
                int k2 = 0;
                while (k2 < diffs.size()) {
                    PdfObject obj = diffs.getPdfObject(k2);
                    if (obj.isNumber()) {
                        currentNumber = ((PdfNumber)obj).intValue();
                    } else {
                        int[] c2 = GlyphList.nameToUnicode(PdfName.decodeName(((PdfName)obj).toString()));
                        if (c2 != null && c2.length > 0) {
                            this.uni2byte.put(c2[0], currentNumber);
                            this.diffmap.put(c2[0], currentNumber);
                        }
                        ++currentNumber;
                    }
                    ++k2;
                }
            }
        }
        PdfArray newWidths = this.font.getAsArray(PdfName.WIDTHS);
        PdfNumber first = this.font.getAsNumber(PdfName.FIRSTCHAR);
        PdfNumber last = this.font.getAsNumber(PdfName.LASTCHAR);
        if (BuiltinFonts14.containsKey(this.fontName)) {
            int n2;
            BaseFont bf;
            try {
                bf = BaseFont.createFont(this.fontName, "Cp1252", false);
            }
            catch (Exception e2) {
                throw new ExceptionConverter(e2);
            }
            int[] e3 = this.uni2byte.toOrderedKeys();
            int k3 = 0;
            while (k3 < e3.length) {
                n2 = this.uni2byte.get(e3[k3]);
                this.widths[n2] = bf.getRawWidth(n2, GlyphList.unicodeToName(e3[k3]));
                ++k3;
            }
            if (this.diffmap != null) {
                e3 = this.diffmap.toOrderedKeys();
                k3 = 0;
                while (k3 < e3.length) {
                    n2 = this.diffmap.get(e3[k3]);
                    this.widths[n2] = bf.getRawWidth(n2, GlyphList.unicodeToName(e3[k3]));
                    ++k3;
                }
                this.diffmap = null;
            }
            this.Ascender = bf.getFontDescriptor(1, 1000.0f);
            this.CapHeight = bf.getFontDescriptor(2, 1000.0f);
            this.Descender = bf.getFontDescriptor(3, 1000.0f);
            this.ItalicAngle = bf.getFontDescriptor(4, 1000.0f);
            this.llx = bf.getFontDescriptor(5, 1000.0f);
            this.lly = bf.getFontDescriptor(6, 1000.0f);
            this.urx = bf.getFontDescriptor(7, 1000.0f);
            this.ury = bf.getFontDescriptor(8, 1000.0f);
        }
        if (first != null && last != null && newWidths != null) {
            int f2 = first.intValue();
            int k4 = 0;
            while (k4 < newWidths.size()) {
                this.widths[f2 + k4] = newWidths.getAsNumber(k4).intValue();
                ++k4;
            }
        }
        this.fillFontDesc(this.font.getAsDict(PdfName.FONTDESCRIPTOR));
    }

    private void fillFontDesc(PdfDictionary fontDesc) {
        PdfArray bbox;
        if (fontDesc == null) {
            return;
        }
        PdfNumber v2 = fontDesc.getAsNumber(PdfName.ASCENT);
        if (v2 != null) {
            this.Ascender = v2.floatValue();
        }
        if ((v2 = fontDesc.getAsNumber(PdfName.CAPHEIGHT)) != null) {
            this.CapHeight = v2.floatValue();
        }
        if ((v2 = fontDesc.getAsNumber(PdfName.DESCENT)) != null) {
            this.Descender = v2.floatValue();
        }
        if ((v2 = fontDesc.getAsNumber(PdfName.ITALICANGLE)) != null) {
            this.ItalicAngle = v2.floatValue();
        }
        if ((bbox = fontDesc.getAsArray(PdfName.FONTBBOX)) != null) {
            float t2;
            this.llx = bbox.getAsNumber(0).floatValue();
            this.lly = bbox.getAsNumber(1).floatValue();
            this.urx = bbox.getAsNumber(2).floatValue();
            this.ury = bbox.getAsNumber(3).floatValue();
            if (this.llx > this.urx) {
                t2 = this.llx;
                this.llx = this.urx;
                this.urx = t2;
            }
            if (this.lly > this.ury) {
                t2 = this.lly;
                this.lly = this.ury;
                this.ury = t2;
            }
        }
    }

    private void fillEncoding(PdfName encoding) {
        if (PdfName.MAC_ROMAN_ENCODING.equals(encoding) || PdfName.WIN_ANSI_ENCODING.equals(encoding)) {
            byte[] b2 = new byte[256];
            int k2 = 0;
            while (k2 < 256) {
                b2[k2] = (byte)k2;
                ++k2;
            }
            String enc = "Cp1252";
            if (PdfName.MAC_ROMAN_ENCODING.equals(encoding)) {
                enc = "MacRoman";
            }
            String cv = PdfEncodings.convertToString(b2, enc);
            char[] arr = cv.toCharArray();
            int k3 = 0;
            while (k3 < 256) {
                this.uni2byte.put(arr[k3], k3);
                ++k3;
            }
        } else {
            int k4 = 0;
            while (k4 < 256) {
                this.uni2byte.put(stdEnc[k4], k4);
                ++k4;
            }
        }
    }

    @Override
    public String[][] getFamilyFontName() {
        return this.getFullFontName();
    }

    @Override
    public float getFontDescriptor(int key, float fontSize) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getFontDescriptor(key, fontSize);
        }
        switch (key) {
            case 1: 
            case 9: {
                return this.Ascender * fontSize / 1000.0f;
            }
            case 2: {
                return this.CapHeight * fontSize / 1000.0f;
            }
            case 3: 
            case 10: {
                return this.Descender * fontSize / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return this.llx * fontSize / 1000.0f;
            }
            case 6: {
                return this.lly * fontSize / 1000.0f;
            }
            case 7: {
                return this.urx * fontSize / 1000.0f;
            }
            case 8: {
                return this.ury * fontSize / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (this.urx - this.llx) * fontSize / 1000.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.fontName}};
    }

    @Override
    public String[][] getAllNameEntries() {
        return new String[][]{{"4", "", "", "", this.fontName}};
    }

    @Override
    public int getKerning(int char1, int char2) {
        return 0;
    }

    @Override
    public String getPostscriptFontName() {
        return this.fontName;
    }

    @Override
    int getRawWidth(int c2, String name) {
        return 0;
    }

    @Override
    public boolean hasKernPairs() {
        return false;
    }

    @Override
    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
    }

    @Override
    public PdfStream getFullFontStream() {
        return null;
    }

    @Override
    public int getWidth(int char1) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getWidth(char1);
        }
        if (this.isType0) {
            int[] ws = this.metrics.get(new Integer(char1));
            if (ws != null) {
                return ws[1];
            }
            return 0;
        }
        return super.getWidth(char1);
    }

    @Override
    public int getWidth(String text) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getWidth(text);
        }
        if (this.isType0) {
            char[] chars = text.toCharArray();
            int len = chars.length;
            int total = 0;
            int k2 = 0;
            while (k2 < len) {
                int[] ws = this.metrics.get(new Integer(chars[k2]));
                if (ws != null) {
                    total += ws[1];
                }
                ++k2;
            }
            return total;
        }
        return super.getWidth(text);
    }

    @Override
    byte[] convertToBytes(String text) {
        if (this.cjkMirror != null) {
            return PdfEncodings.convertToBytes(text, "UnicodeBigUnmarked");
        }
        if (this.isType0) {
            char[] chars = text.toCharArray();
            int len = chars.length;
            byte[] b2 = new byte[len * 2];
            int bptr = 0;
            int k2 = 0;
            while (k2 < len) {
                int[] ws = this.metrics.get(new Integer(chars[k2]));
                if (ws != null) {
                    int g2 = ws[0];
                    b2[bptr++] = (byte)(g2 / 256);
                    b2[bptr++] = (byte)g2;
                }
                ++k2;
            }
            if (bptr == b2.length) {
                return b2;
            }
            byte[] nb = new byte[bptr];
            System.arraycopy(b2, 0, nb, 0, bptr);
            return nb;
        }
        char[] cc = text.toCharArray();
        byte[] b3 = new byte[cc.length];
        int ptr = 0;
        int k3 = 0;
        while (k3 < cc.length) {
            if (this.uni2byte.containsKey(cc[k3])) {
                b3[ptr++] = (byte)this.uni2byte.get(cc[k3]);
            }
            ++k3;
        }
        if (ptr == b3.length) {
            return b3;
        }
        byte[] b2 = new byte[ptr];
        System.arraycopy(b3, 0, b2, 0, ptr);
        return b2;
    }

    @Override
    byte[] convertToBytes(int char1) {
        if (this.cjkMirror != null) {
            return PdfEncodings.convertToBytes((char)char1, "UnicodeBigUnmarked");
        }
        if (this.isType0) {
            int[] ws = this.metrics.get(new Integer(char1));
            if (ws != null) {
                int g2 = ws[0];
                return new byte[]{(byte)(g2 / 256), (byte)g2};
            }
            return new byte[0];
        }
        if (this.uni2byte.containsKey(char1)) {
            return new byte[]{(byte)this.uni2byte.get(char1)};
        }
        return new byte[0];
    }

    PdfIndirectReference getIndirectReference() {
        return this.refFont;
    }

    @Override
    public boolean charExists(int c2) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.charExists(c2);
        }
        if (this.isType0) {
            return this.metrics.containsKey(new Integer(c2));
        }
        return super.charExists(c2);
    }

    @Override
    public void setPostscriptFontName(String name) {
    }

    @Override
    public boolean setKerning(int char1, int char2, int kern) {
        return false;
    }

    @Override
    public int[] getCharBBox(int c2) {
        return null;
    }

    @Override
    protected int[] getRawCharBBox(int c2, String name) {
        return null;
    }

    IntHashtable getUni2Byte() {
        return this.uni2byte;
    }
}

