/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final String SERVICE = "KeyPairGenerator";
    private static Engine engine = new Engine("KeyPairGenerator");
    private static SecureRandom random = new SecureRandom();
    private Provider provider;
    private String algorithm;

    protected KeyPairGenerator(String string) {
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        Engine.ServiceResult serviceResult = engine.getInstance(string, null);
        if (serviceResult.spi instanceof KeyPairGenerator) {
            KeyPairGenerator keyPairGenerator = (KeyPairGenerator)serviceResult.spi;
            keyPairGenerator.algorithm = string;
            keyPairGenerator.provider = serviceResult.provider;
            return keyPairGenerator;
        }
        KeyPairGeneratorImpl keyPairGeneratorImpl = new KeyPairGeneratorImpl((KeyPairGeneratorSpi)serviceResult.spi, serviceResult.provider, string);
        return keyPairGeneratorImpl;
    }

    public static KeyPairGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.02"));
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return KeyPairGenerator.getInstance(string, provider);
    }

    public static KeyPairGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException(Messages.getString("security.04"));
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        Engine.ServiceResult serviceResult = engine.getInstance(string, provider, null);
        if (serviceResult.spi instanceof KeyPairGenerator) {
            KeyPairGenerator keyPairGenerator = (KeyPairGenerator)serviceResult.spi;
            keyPairGenerator.algorithm = string;
            keyPairGenerator.provider = provider;
            return keyPairGenerator;
        }
        KeyPairGeneratorImpl keyPairGeneratorImpl = new KeyPairGeneratorImpl((KeyPairGeneratorSpi)serviceResult.spi, provider, string);
        return keyPairGeneratorImpl;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void initialize(int n2) {
        this.initialize(n2, random);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.initialize(algorithmParameterSpec, random);
    }

    public final KeyPair genKeyPair() {
        return this.generateKeyPair();
    }

    @Override
    public KeyPair generateKeyPair() {
        return null;
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
    }

    private static class KeyPairGeneratorImpl
    extends KeyPairGenerator {
        private KeyPairGeneratorSpi spiImpl;

        private KeyPairGeneratorImpl(KeyPairGeneratorSpi keyPairGeneratorSpi, Provider provider, String string) {
            super(string);
            ((KeyPairGenerator)this).provider = provider;
            this.spiImpl = keyPairGeneratorSpi;
        }

        @Override
        public void initialize(int n2, SecureRandom secureRandom) {
            this.spiImpl.initialize(n2, secureRandom);
        }

        @Override
        public KeyPair generateKeyPair() {
            return this.spiImpl.generateKeyPair();
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.spiImpl.initialize(algorithmParameterSpec, secureRandom);
        }
    }
}

