/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.base.JRBaseDatasetRun;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignDatasetRun
extends JRBaseDatasetRun
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    private Map<String, JRDatasetParameter> parametersMap = new HashMap<String, JRDatasetParameter>();
    private List<JRDatasetParameter> parametersList = new ArrayList<JRDatasetParameter>();
    public static final String PROPERTY_CONNECTION_EXPRESSION = "connectionExpression";
    public static final String PROPERTY_DATASET_NAME = "datasetName";
    public static final String PROPERTY_DATA_SOURCE_EXPRESSION = "dataSourceExpression";
    public static final String PROPERTY_PARAMETERS_MAP_EXPRESSION = "parametersMapExpression";
    public static final String PROPERTY_PARAMETERS = "parameters";
    private transient JRPropertyChangeSupport eventSupport;

    public void addParameter(JRDatasetParameter parameter) throws JRException {
        if (this.parametersMap.containsKey(parameter.getName())) {
            throw new JRException("Duplicate declaration of dataset parameter : " + parameter.getName());
        }
        this.parametersMap.put(parameter.getName(), parameter);
        this.parametersList.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, parameter, this.parametersList.size() - 1);
    }

    public JRDatasetParameter removeParameter(String parameterName) {
        JRDatasetParameter param = this.parametersMap.remove(parameterName);
        if (param != null) {
            int idx = this.parametersList.indexOf(param);
            if (idx >= 0) {
                this.parametersList.remove(idx);
            }
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, param, idx);
        }
        return param;
    }

    public JRDatasetParameter removeParameter(JRDatasetParameter parameter) {
        return this.removeParameter(parameter.getName());
    }

    public void setConnectionExpression(JRExpression connectionExpression) {
        JRExpression old = this.connectionExpression;
        this.connectionExpression = connectionExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_CONNECTION_EXPRESSION, old, this.connectionExpression);
    }

    public void setDatasetName(String datasetName) {
        String old = this.datasetName;
        this.datasetName = datasetName;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET_NAME, old, this.datasetName);
    }

    public void setDataSourceExpression(JRExpression dataSourceExpression) {
        JRExpression old = this.dataSourceExpression;
        this.dataSourceExpression = dataSourceExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_DATA_SOURCE_EXPRESSION, old, this.dataSourceExpression);
    }

    public void setParametersMapExpression(JRExpression parametersMapExpression) {
        JRExpression old = this.parametersMapExpression;
        this.parametersMapExpression = parametersMapExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_PARAMETERS_MAP_EXPRESSION, old, this.parametersMapExpression);
    }

    public JRDatasetParameter[] getParameters() {
        JRDatasetParameter[] params = new JRDatasetParameter[this.parametersList.size()];
        this.parametersList.toArray(params);
        return params;
    }

    public Object clone() {
        JRDesignDatasetRun clone = (JRDesignDatasetRun)super.clone();
        if (this.parametersList != null) {
            clone.parametersList = new ArrayList<JRDatasetParameter>(this.parametersList.size());
            clone.parametersMap = new HashMap<String, JRDatasetParameter>(this.parametersList.size());
            for (int i2 = 0; i2 < this.parametersList.size(); ++i2) {
                JRDatasetParameter parameter = (JRDatasetParameter)JRCloneUtils.nullSafeClone((JRCloneable)this.parametersList.get(i2));
                clone.parametersList.add(parameter);
                clone.parametersMap.put(parameter.getName(), parameter);
            }
        }
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignDatasetRun jRDesignDatasetRun = this;
        synchronized (jRDesignDatasetRun) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

