/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizationHelper;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.ClassLoaderResource;
import net.sf.jasperreports.engine.util.ContextClassLoaderObjectInputStream;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JRLoader {
    private static final Log log = LogFactory.getLog(JRLoader.class);

    public static Object loadObject(String fileName) throws JRException {
        return JRLoader.loadObjectFromFile(fileName);
    }

    public static Object loadObjectFromFile(String fileName) throws JRException {
        return JRLoader.loadObject(new File(fileName));
    }

    public static Object loadObject(File file) throws JRException {
        if (!file.exists() || !file.isFile()) {
            throw new JRException(new FileNotFoundException(String.valueOf(file)));
        }
        Object obj = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            BufferedInputStream bufferedIn = new BufferedInputStream(fis);
            ois = new ContextClassLoaderObjectInputStream(bufferedIn);
            obj = ois.readObject();
        }
        catch (IOException e2) {
            throw new JRException("Error loading object from file : " + file, e2);
        }
        catch (ClassNotFoundException e3) {
            throw new JRException("Class not found when loading object from file : " + file, e3);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e4) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e5) {}
            }
        }
        return obj;
    }

    public static Object loadObject(URL url) throws JRException {
        Object obj = null;
        InputStream is = null;
        ObjectInputStream ois = null;
        try {
            is = url.openStream();
            ois = new ContextClassLoaderObjectInputStream(is);
            obj = ois.readObject();
        }
        catch (IOException e2) {
            throw new JRException("Error loading object from URL : " + url, e2);
        }
        catch (ClassNotFoundException e3) {
            throw new JRException("Class not found when loading object from URL : " + url, e3);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e4) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e5) {}
            }
        }
        return obj;
    }

    public static Object loadObject(InputStream is) throws JRException {
        Object obj = null;
        ContextClassLoaderObjectInputStream ois = null;
        try {
            ois = new ContextClassLoaderObjectInputStream(is);
            obj = ois.readObject();
        }
        catch (IOException e2) {
            throw new JRException("Error loading object from InputStream", e2);
        }
        catch (ClassNotFoundException e3) {
            throw new JRException("Class not found when loading object from InputStream", e3);
        }
        return obj;
    }

    public static Object loadObjectFromLocation(String location) throws JRException {
        return JRLoader.loadObjectFromLocation(location, null, null, null);
    }

    public static Object loadObjectFromLocation(String location, ClassLoader classLoader) throws JRException {
        return JRLoader.loadObjectFromLocation(location, classLoader, null, null);
    }

    public static Object loadObjectFromLocation(String location, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory, FileResolver fileResolver) throws JRException {
        URL url = JRResourcesUtil.createURL(location, urlHandlerFactory);
        if (url != null) {
            return JRLoader.loadObject(url);
        }
        File file = JRResourcesUtil.resolveFile(location, fileResolver);
        if (file != null) {
            return JRLoader.loadObject(file);
        }
        url = JRResourcesUtil.findClassLoaderResource(location, classLoader);
        if (url != null) {
            return JRLoader.loadObject(url);
        }
        throw new JRException("Could not load object from location : " + location);
    }

    public static InputStream getInputStream(File file) throws JRException {
        if (!file.exists() || !file.isFile()) {
            throw new JRException(new FileNotFoundException(String.valueOf(file)));
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (IOException e2) {
            throw new JRException("Error opening input stream from file : " + file, e2);
        }
        return fis;
    }

    public static InputStream getInputStream(URL url) throws JRException {
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e2) {
            throw new JRException("Error opening input stream from URL : " + url, e2);
        }
        return is;
    }

    public static InputStream getInputStreamFromLocation(String location) throws JRException {
        return JRLoader.getInputStreamFromLocation(location, null, null, null);
    }

    public static InputStream getInputStreamFromLocation(String location, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory, FileResolver fileResolver) throws JRException {
        URL url = JRResourcesUtil.createURL(location, urlHandlerFactory);
        if (url != null) {
            return JRLoader.getInputStream(url);
        }
        File file = JRResourcesUtil.resolveFile(location, fileResolver);
        if (file != null) {
            return JRLoader.getInputStream(file);
        }
        url = JRResourcesUtil.findClassLoaderResource(location, classLoader);
        if (url != null) {
            return JRLoader.getInputStream(url);
        }
        throw new JRException("Could not load object from location : " + location);
    }

    public static byte[] loadBytes(File file) throws JRException {
        ByteArrayOutputStream baos = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = fis.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e2) {
            throw new JRException("Error loading byte data : " + file, e2);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e3) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e4) {}
            }
        }
        return baos.toByteArray();
    }

    public static byte[] loadBytes(URL url) throws JRException {
        ByteArrayOutputStream baos = null;
        InputStream is = null;
        try {
            is = url.openStream();
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e2) {
            throw new JRException("Error loading byte data : " + url, e2);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e3) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e4) {}
            }
        }
        return baos.toByteArray();
    }

    public static byte[] loadBytes(InputStream is) throws JRException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e2) {
            throw new JRException("Error loading byte data from input stream.", e2);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e3) {}
            }
        }
        return baos.toByteArray();
    }

    public static byte[] loadBytesFromResource(String resourceName) throws JRException {
        return JRLoader.loadBytesFromResource(resourceName, null);
    }

    public static byte[] loadBytesFromResource(String resourceName, ClassLoader classLoader) throws JRException {
        URL url = JRResourcesUtil.findClassLoaderResource(resourceName, classLoader);
        if (url != null) {
            return JRLoader.loadBytes(url);
        }
        throw new JRException("Resource '" + resourceName + "' not found.");
    }

    public static byte[] loadBytesFromLocation(String location) throws JRException {
        return JRLoader.loadBytesFromLocation(location, null, null, null);
    }

    public static byte[] loadBytesFromLocation(String location, ClassLoader classLoader) throws JRException {
        return JRLoader.loadBytesFromLocation(location, classLoader, null, null);
    }

    public static byte[] loadBytesFromLocation(String location, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory) throws JRException {
        return JRLoader.loadBytesFromLocation(location, classLoader, urlHandlerFactory, null);
    }

    public static byte[] loadBytesFromLocation(String location, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory, FileResolver fileResolver) throws JRException {
        URL url = JRResourcesUtil.createURL(location, urlHandlerFactory);
        if (url != null) {
            return JRLoader.loadBytes(url);
        }
        File file = JRResourcesUtil.resolveFile(location, fileResolver);
        if (file != null) {
            return JRLoader.loadBytes(file);
        }
        url = JRResourcesUtil.findClassLoaderResource(location, classLoader);
        if (url != null) {
            return JRLoader.loadBytes(url);
        }
        throw new JRException("Byte data not found at location : " + location);
    }

    public static InputStream getLocationInputStream(String location) throws JRException {
        InputStream is = null;
        is = JRLoader.getResourceInputStream(location);
        if (is == null) {
            is = JRLoader.getFileInputStream(location);
        }
        if (is == null) {
            is = JRLoader.getURLInputStream(location);
        }
        return is;
    }

    public static InputStream getFileInputStream(String filename) throws JRException {
        FileInputStream is = null;
        File file = new File(filename);
        if (file.exists() && file.isFile()) {
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e2) {
                throw new JRException("Error opening file " + filename, e2);
            }
        }
        return is;
    }

    public static InputStream getResourceInputStream(String resource) {
        InputStream is = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            is = classLoader.getResourceAsStream(resource);
        }
        if (is == null) {
            classLoader = JRLoader.class.getClassLoader();
            if (classLoader != null) {
                is = classLoader.getResourceAsStream(resource);
            }
            if (is == null) {
                is = JRProperties.class.getResourceAsStream("/" + resource);
            }
        }
        return is;
    }

    public static List<URL> getResources(String resource) {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        JRLoader.collectResources(resource, JRLoader.class.getClassLoader(), resources);
        JRLoader.collectResources(resource, Thread.currentThread().getContextClassLoader(), resources);
        return new ArrayList<URL>(resources);
    }

    protected static void collectResources(String resourceName, ClassLoader classLoader, Set<URL> resources) {
        if (classLoader != null) {
            try {
                Enumeration<URL> urls = classLoader.getResources(resourceName);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    resources.add(url);
                }
            }
            catch (IOException e2) {
                throw new JRRuntimeException(e2);
            }
        }
    }

    public static List<ClassLoaderResource> getClassLoaderResources(String resource) {
        LinkedHashMap<URL, ClassLoaderResource> resources = new LinkedHashMap<URL, ClassLoaderResource>();
        JRLoader.collectResources(resource, JRLoader.class.getClassLoader(), resources);
        JRLoader.collectResources(resource, Thread.currentThread().getContextClassLoader(), resources);
        return new ArrayList<ClassLoaderResource>(resources.values());
    }

    protected static void collectResources(String resourceName, ClassLoader classLoader, Map<URL, ClassLoaderResource> resources) {
        if (classLoader == null) {
            return;
        }
        try {
            LinkedList<ClassLoader> classloaders = new LinkedList<ClassLoader>();
            ClassLoader ancestorLoader = classLoader;
            while (ancestorLoader != null) {
                classloaders.addFirst(ancestorLoader);
                try {
                    ancestorLoader = ancestorLoader.getParent();
                }
                catch (SecurityException e2) {
                    ancestorLoader = null;
                }
            }
            for (ClassLoader ancestor : classloaders) {
                Enumeration<URL> urls = ancestor.getResources(resourceName);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (resources.containsKey(url)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Found resource " + resourceName + " at " + url + " in classloader " + ancestor);
                    }
                    ClassLoaderResource resource = new ClassLoaderResource(url, ancestor);
                    resources.put(url, resource);
                }
            }
        }
        catch (IOException e3) {
            throw new JRRuntimeException(e3);
        }
    }

    public static URL getResource(String resource) {
        URL location = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            location = classLoader.getResource(resource);
        }
        if (location == null) {
            classLoader = JRLoader.class.getClassLoader();
            if (classLoader != null) {
                location = classLoader.getResource(resource);
            }
            if (location == null) {
                location = JRProperties.class.getResource("/" + resource);
            }
        }
        return location;
    }

    public static InputStream getURLInputStream(String spec) throws JRException {
        InputStream is = null;
        try {
            URL url = new URL(spec);
            is = url.openStream();
        }
        catch (MalformedURLException e2) {
        }
        catch (IOException e3) {
            throw new JRException("Error opening URL " + spec, e3);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JasperPrint loadJasperPrintFromFile(String fileName, JRVirtualizer virtualizer) throws JRException {
        if (virtualizer != null) {
            JRVirtualizationHelper.setThreadVirtualizer(virtualizer);
        }
        try {
            JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(fileName);
            return jasperPrint;
        }
        finally {
            if (virtualizer != null) {
                JRVirtualizationHelper.clearThreadVirtualizer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JasperPrint loadJasperPrint(File file, JRVirtualizer virtualizer) throws JRException {
        if (virtualizer != null) {
            JRVirtualizationHelper.setThreadVirtualizer(virtualizer);
        }
        try {
            JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(file);
            return jasperPrint;
        }
        finally {
            if (virtualizer != null) {
                JRVirtualizationHelper.clearThreadVirtualizer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JasperPrint loadJasperPrint(URL url, JRVirtualizer virtualizer) throws JRException {
        if (virtualizer != null) {
            JRVirtualizationHelper.setThreadVirtualizer(virtualizer);
        }
        try {
            JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(url);
            return jasperPrint;
        }
        finally {
            if (virtualizer != null) {
                JRVirtualizationHelper.clearThreadVirtualizer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JasperPrint loadJasperPrint(InputStream is, JRVirtualizer virtualizer) throws JRException {
        if (virtualizer != null) {
            JRVirtualizationHelper.setThreadVirtualizer(virtualizer);
        }
        try {
            JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            return jasperPrint;
        }
        finally {
            if (virtualizer != null) {
                JRVirtualizationHelper.clearThreadVirtualizer();
            }
        }
    }

    private JRLoader() {
    }
}

