/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.internal.nls;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.harmony.kernel.vm.VM;

public class Messages {
    private static ResourceBundle bundle = null;

    public static String getString(String string) {
        if (bundle == null) {
            return string;
        }
        try {
            return bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string;
        }
    }

    public static String getString(String string, Object object) {
        return Messages.getString(string, new Object[]{object});
    }

    public static String getString(String string, int n2) {
        return Messages.getString(string, new Object[]{Integer.toString(n2)});
    }

    public static String getString(String string, char c2) {
        return Messages.getString(string, new Object[]{String.valueOf(c2)});
    }

    public static String getString(String string, Object object, Object object2) {
        return Messages.getString(string, new Object[]{object, object2});
    }

    public static String getString(String string, Object[] objectArray) {
        String string2 = string;
        if (bundle != null) {
            try {
                string2 = bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return Messages.format(string2, objectArray);
    }

    public static String format(String string, Object[] objectArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string.length() + objectArray.length * 20);
        String[] stringArray = new String[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            stringArray[n2] = objectArray[n2] == null ? "<null>" : objectArray[n2].toString();
        }
        n2 = 0;
        int n3 = string.indexOf(123, 0);
        while (n3 >= 0) {
            if (n3 != 0 && string.charAt(n3 - 1) == '\\') {
                if (n3 != 1) {
                    stringBuilder.append(string.substring(n2, n3 - 1));
                }
                stringBuilder.append('{');
                n2 = n3 + 1;
            } else if (n3 > string.length() - 3) {
                stringBuilder.append(string.substring(n2, string.length()));
                n2 = string.length();
            } else {
                byte by = (byte)Character.digit(string.charAt(n3 + 1), 10);
                if (by < 0 || string.charAt(n3 + 2) != '}') {
                    stringBuilder.append(string.substring(n2, n3 + 1));
                    n2 = n3 + 1;
                } else {
                    stringBuilder.append(string.substring(n2, n3));
                    if (by >= stringArray.length) {
                        stringBuilder.append("<missing argument>");
                    } else {
                        stringBuilder.append(stringArray[by]);
                    }
                    n2 = n3 + 3;
                }
            }
            n3 = string.indexOf(123, n2);
        }
        if (n2 < string.length()) {
            stringBuilder.append(string.substring(n2, string.length()));
        }
        return stringBuilder.toString();
    }

    public static ResourceBundle setLocale(final Locale locale, final String string) {
        try {
            final ClassLoader classLoader = VM.bootCallerClassLoader();
            return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return ResourceBundle.getBundle(string, locale, classLoader != null ? classLoader : ClassLoader.getSystemClassLoader());
                }
            });
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    static {
        try {
            bundle = Messages.setLocale(Locale.getDefault(), "org.apache.harmony.security.internal.nls.messages");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

