/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Dimension;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import util.KeyStoreEntry;
import util.KeyStoreUtils;

public class KeyStoreTable
extends JTable
implements ListSelectionListener {
    protected List<KeyStoreEntry> tableEntries;
    private KeyStoreEntry selectedKSEntry;
    private KeyStore ks;
    private static final String[] columnNames = new String[]{"Subject", "Serial No.", "Issuer", "Expiration Date"};
    private AbstractTableModel tableModel = new AbstractTableModel(){

        @Override
        public String getColumnName(int col) {
            return columnNames[col].toString();
        }

        @Override
        public int getRowCount() {
            return KeyStoreTable.this.tableEntries.size();
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            KeyStoreEntry entry = KeyStoreTable.this.tableEntries.get(row);
            switch (col) {
                case 0: {
                    return entry.getSubjectCN();
                }
                case 1: {
                    return entry.getSrlNo().toString(16);
                }
                case 2: {
                    return entry.getIssuerCN();
                }
                case 3: {
                    return entry.getExpirationDate();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    };

    public KeyStoreTable(KeyStore ks) throws KeyStoreException, CertificateException {
        this.ks = ks;
        this.tableEntries = KeyStoreUtils.getTableEntries(this.ks);
        ListSelectionModel rowSM = this.getSelectionModel();
        rowSM.addListSelectionListener(this);
        this.setSelectionMode(0);
        this.setModel(this.tableModel);
        this.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.setAutoResizeMode(0);
        this.setPreferredScrollableViewportSize(new Dimension(550, 100));
    }

    @Override
    public void valueChanged(ListSelectionEvent e2) {
        KeyStoreEntry kse;
        this.repaint();
        ListSelectionModel lsm = (ListSelectionModel)e2.getSource();
        this.selectedKSEntry = lsm.isSelectionEmpty() ? null : (kse = this.tableEntries.get(lsm.getMinSelectionIndex()));
    }

    public KeyStoreEntry getSelectedEntry() {
        if (this.selectedKSEntry == null) {
            return null;
        }
        return this.selectedKSEntry;
    }
}

