/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class OriginatorInfo
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_CERTS = 0;
    private static final byte TAG_CRLS = 1;
    private Certificate[] certs;
    private CRL[] crls;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.OriginatorInfo";
    private volatile int cachedHashVal = 0;

    public OriginatorInfo(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "OriginatorInfo", (Object)der);
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public OriginatorInfo(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "OriginatorInfo", der, provider);
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public OriginatorInfo(Certificate[] certsIn, CRL[] crlsIn) {
        this(certsIn, crlsIn, null);
        if (debug != null) {
            debug.entry(16384L, className, "OriginatorInfo", certsIn, crlsIn);
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public OriginatorInfo(Certificate[] certsIn, CRL[] crlsIn, String provider) {
        super(provider);
        int i2;
        if (debug != null) {
            Object[] parms = new Object[]{certsIn, crlsIn, provider};
            debug.entry(16384L, (Object)className, "OriginatorInfo", parms);
        }
        if (certsIn != null) {
            for (int i3 = 0; i3 < certsIn.length; ++i3) {
                if (certsIn[i3] instanceof X509Certificate) continue;
                if (debug != null) {
                    debug.text(16384L, className, "OriginatorInfo", "Invalid certificate type for element " + i3 + ".  Only X509 certificates are supported.");
                }
                throw new IllegalArgumentException("Invalid certificate type " + certsIn[i3].getClass().getName() + " for element " + i3 + ".  Only X509 certificates are supported.");
            }
        }
        this.certs = certsIn;
        if (crlsIn != null && (i2 = 0) < crlsIn.length) {
            if (!(crlsIn[i2] instanceof X509CRL) && debug != null) {
                debug.text(16384L, className, "OriginatorInfo", "Invalid CRL type for element " + i2 + ".  Only X509 CRLs are supported.");
            }
            throw new IllegalArgumentException("Invalid CRL type for element " + i2 + ".  Only X509 CRLs are supported.");
        }
        this.crls = crlsIn;
        if (debug != null) {
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public OriginatorInfo(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "OriginatorInfo", filename, new Boolean(base64));
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public OriginatorInfo(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "OriginatorInfo", parms);
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            OriginatorInfo result = new OriginatorInfo(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        DerEncoder[] temps;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        try {
            if (this.certs != null && this.certs.length > 0) {
                temps = new DerOutputStream[this.certs.length];
                for (int i2 = 0; i2 < this.certs.length; ++i2) {
                    temps[i2] = new DerOutputStream();
                    ((OutputStream)((Object)temps[i2])).write(this.certs[i2].getEncoded());
                }
                DerOutputStream tmpout = new DerOutputStream();
                tmpout.putOrderedSetOf((byte)49, temps);
                bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
            }
        }
        catch (CertificateEncodingException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e2);
                debug.text(16384L, className, "encode", "Error encoding certificates.");
            }
            throw new IOException("Error encoding certificates.");
        }
        try {
            if (this.crls != null && this.crls.length > 0) {
                temps = new DerOutputStream[this.crls.length];
                for (int i3 = 0; i3 < this.crls.length; ++i3) {
                    if (!(this.crls[i3] instanceof X509CRL)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element crls[" + i3 + "] has a type of " + this.crls[i3].getClass().getName() + ".  Only instances of X509CRL are supported.");
                        }
                        throw new IOException("Element crls[" + i3 + "] has a type of " + this.crls[i3].getClass().getName() + ".  Only instances of X509CRL are supported.");
                    }
                    temps[i3] = new DerOutputStream();
                    X509CRL x509crl = (X509CRL)this.crls[i3];
                    ((OutputStream)((Object)temps[i3])).write(x509crl.getEncoded());
                }
                DerOutputStream tmpout = new DerOutputStream();
                tmpout.putOrderedSetOf((byte)49, temps);
                bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmpout);
            }
        }
        catch (CRLException e3) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding crls.");
            }
            throw new IOException("Error encoding crls.");
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "OriginatorInfo parsing error");
            }
            throw new IOException("OriginatorInfo parsing error");
        }
        try {
            while (encoding.getData().available() != 0) {
                DerValue[] ders;
                DerInputStream derin;
                DerValue opt = encoding.getData().getDerValue();
                if (opt.isContextSpecific((byte)0) && opt.isConstructed()) {
                    derin = new DerInputStream(opt.toByteArray());
                    ders = derin.getSet(1, true);
                    this.certs = new X509Certificate[ders.length];
                    Object cf = null;
                    for (int i2 = 0; i2 < ders.length; ++i2) {
                        this.certs[i2] = new X509CertImpl(ders[i2].toByteArray());
                    }
                }
                if (!opt.isContextSpecific((byte)1) || !opt.isConstructed()) continue;
                derin = new DerInputStream(opt.toByteArray());
                ders = derin.getSet(1, true);
                this.crls = new X509CRL[ders.length];
                for (int i3 = 0; i3 < ders.length; ++i3) {
                    this.crls[i3] = new X509CRLImpl(ders[i3].toByteArray());
                }
            }
        }
        catch (CertificateException e2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "error decoding certificates " + e2);
            }
            throw new IOException("error decoding certificates " + e2);
        }
        catch (CRLException e2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "error decoding certificates " + e2);
            }
            throw new IOException("error decoding crls " + e2);
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof OriginatorInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((OriginatorInfo)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e2);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Certificate[] getCertificates() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificates");
        }
        if (this.certs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificates", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificates", this.certs.clone());
        }
        return (Certificate[])this.certs.clone();
    }

    public CRL[] getCRLs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCRLs");
        }
        if (this.crls == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCRLs", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCRLs", this.crls.clone());
        }
        return (CRL[])this.crls.clone();
    }

    @Override
    public String toString() {
        int i2;
        String out = "";
        out = out + "\tcertificates: ";
        if (this.certs == null || this.certs.length == 0) {
            out = out + "null";
        } else {
            for (i2 = 0; i2 < this.certs.length; ++i2) {
                out = out + "\r\n\tcertificate[" + i2 + "] :\r\n" + this.certs[i2];
            }
        }
        out = out + "\r\n\tcertificate revocation lists: ";
        if (this.crls == null || this.crls.length == 0) {
            out = out + "null";
        } else {
            for (i2 = 0; i2 < this.crls.length; ++i2) {
                out = out + "\r\n\tcrl[" + i2 + "] :\r\n" + this.crls[i2];
            }
        }
        return out;
    }
}

