/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;

public abstract class JRSqlAbstractEqualClause
implements JRClauseFunction {
    protected static final int POSITION_DB_COLUMN = 1;
    protected static final int POSITION_PARAMETER = 2;

    protected JRSqlAbstractEqualClause() {
    }

    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        String col = clauseTokens.getToken(1);
        String param = clauseTokens.getToken(2);
        if (col == null) {
            throw new JRRuntimeException("SQL EQUAL clause missing DB column token");
        }
        if (param == null) {
            throw new JRRuntimeException("SQL EQUAL clause missing parameter token");
        }
        StringBuffer sbuffer = queryContext.queryBuffer();
        sbuffer.append(col);
        sbuffer.append(' ');
        this.handleEqualOperator(sbuffer, param, queryContext);
    }

    protected void finalizeClause(StringBuffer sbuffer, String param, JRQueryClauseContext queryContext) {
        sbuffer.append(' ');
        sbuffer.append('?');
        queryContext.addQueryParameter(param);
    }

    protected abstract void handleEqualOperator(StringBuffer var1, String var2, JRQueryClauseContext var3);
}

