/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.xml.ChartEvaluationGroupReference;
import net.sf.jasperreports.engine.xml.ElementReprintGroupReference;
import net.sf.jasperreports.engine.xml.ImageEvaluationGroupReference;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.TextFieldEvaluationGroupReference;
import net.sf.jasperreports.engine.xml.XmlGroupReference;
import net.sf.jasperreports.engine.xml.XmlLoaderReportContext;
import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRXmlLoader {
    private JasperDesign jasperDesign;
    private LinkedList<XmlLoaderReportContext> contextStack = new LinkedList();
    private Map<XmlGroupReference, XmlLoaderReportContext> groupReferences = new HashMap<XmlGroupReference, XmlLoaderReportContext>();
    private Set<JRElementDataset> groupBoundDatasets = new HashSet<JRElementDataset>();
    private List<Exception> errors = new ArrayList<Exception>();
    private Digester digester;
    private boolean ignoreConsistencyProblems;

    public JRXmlLoader(Digester digester) {
        this.digester = digester;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public void addGroupReference(XmlGroupReference reference) {
        XmlLoaderReportContext reportContext = this.getReportContext();
        this.groupReferences.put(reference, reportContext);
    }

    public void addGroupReprintedElement(JRDesignElement element) {
        this.addGroupReference(new ElementReprintGroupReference(element));
    }

    public void addGroupEvaluatedImage(JRDesignImage image) {
        this.addGroupReference(new ImageEvaluationGroupReference(image));
    }

    public void addGroupEvaluatedTextField(JRDesignTextField textField) {
        this.addGroupReference(new TextFieldEvaluationGroupReference(textField));
    }

    public void addGroupEvaluatedChart(JRDesignChart chart) {
        this.addGroupReference(new ChartEvaluationGroupReference(chart));
    }

    public Set<JRElementDataset> getGroupBoundDatasets() {
        return this.groupBoundDatasets;
    }

    public static JasperDesign load(String sourceFileName) throws JRException {
        return JRXmlLoader.load(new File(sourceFileName));
    }

    public static JasperDesign load(File file) throws JRException {
        JasperDesign jasperDesign = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            jasperDesign = JRXmlLoader.load(fis);
        }
        catch (IOException e2) {
            throw new JRException(e2);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e3) {}
            }
        }
        return jasperDesign;
    }

    public static JasperDesign load(InputStream is) throws JRException {
        JasperDesign jasperDesign = null;
        JRXmlLoader xmlLoader = null;
        try {
            xmlLoader = new JRXmlLoader(JRXmlDigesterFactory.createDigester());
        }
        catch (ParserConfigurationException e2) {
            throw new JRException(e2);
        }
        catch (SAXException e3) {
            throw new JRException(e3);
        }
        jasperDesign = xmlLoader.loadXML(is);
        return jasperDesign;
    }

    public JasperDesign loadXML(InputStream is) throws JRException {
        return this.loadXML(new InputSource(is));
    }

    public JasperDesign loadXML(InputSource is) throws JRException {
        try {
            this.digester.push(this);
            this.digester.parse(is);
        }
        catch (SAXException e2) {
            throw new JRException(e2);
        }
        catch (IOException e3) {
            throw new JRException(e3);
        }
        finally {
            this.digester.clear();
        }
        if (this.errors.size() > 0) {
            Exception e4 = this.errors.get(0);
            if (e4 instanceof JRException) {
                throw (JRException)e4;
            }
            throw new JRException(e4);
        }
        this.assignGroupsToVariables(this.jasperDesign.getMainDesignDataset());
        for (JRDesignDataset jRDesignDataset : this.jasperDesign.getDatasetsList()) {
            this.assignGroupsToVariables(jRDesignDataset);
        }
        this.assignGroupReferences();
        this.assignGroupsToDatasets();
        return this.jasperDesign;
    }

    private void assignGroupsToVariables(JRDesignDataset dataset) throws JRException {
        JRVariable[] variables = dataset.getVariables();
        if (variables != null && variables.length > 0) {
            Map<String, JRGroup> groupsMap = dataset.getGroupsMap();
            for (int i2 = 0; i2 < variables.length; ++i2) {
                JRGroup group;
                String groupName;
                JRDesignVariable variable = (JRDesignVariable)variables[i2];
                if (variable.getResetTypeValue() == ResetTypeEnum.GROUP) {
                    groupName = null;
                    group = variable.getResetGroup();
                    if (group != null) {
                        groupName = group.getName();
                        group = groupsMap.get(groupName);
                    }
                    if (!this.ignoreConsistencyProblems && group == null) {
                        throw new JRValidationException("Unknown reset group '" + groupName + "' for variable : " + variable.getName(), variable);
                    }
                    variable.setResetGroup(group);
                } else {
                    variable.setResetGroup(null);
                }
                if (variable.getIncrementTypeValue() == IncrementTypeEnum.GROUP) {
                    groupName = null;
                    group = variable.getIncrementGroup();
                    if (group != null) {
                        groupName = group.getName();
                        group = groupsMap.get(groupName);
                    }
                    if (!this.ignoreConsistencyProblems && group == null) {
                        throw new JRValidationException("Unknown increment group '" + groupName + "' for variable : " + variable.getName(), variable);
                    }
                    variable.setIncrementGroup(group);
                    continue;
                }
                variable.setIncrementGroup(null);
            }
        }
    }

    private void assignGroupReferences() throws JRException {
        for (Map.Entry<XmlGroupReference, XmlLoaderReportContext> entry : this.groupReferences.entrySet()) {
            XmlGroupReference reference = entry.getKey();
            XmlLoaderReportContext context = entry.getValue();
            String groupName = null;
            JRGroup group = reference.getGroupReference();
            if (group != null) {
                groupName = group.getName();
                group = this.resolveGroup(groupName, context);
            }
            if (!this.ignoreConsistencyProblems && group == null) {
                reference.groupNotFound(groupName);
                continue;
            }
            reference.assignGroup(group);
        }
    }

    protected JRGroup resolveGroup(String groupName, XmlLoaderReportContext context) {
        JRGroup group;
        if (context == null) {
            Map<String, JRGroup> groupsMap = this.jasperDesign.getGroupsMap();
            group = groupsMap.get(groupName);
        } else {
            String datasetName = context.getSubdatesetName();
            JRDesignDataset dataset = (JRDesignDataset)this.jasperDesign.getDatasetMap().get(datasetName);
            if (dataset == null) {
                throw new JRRuntimeException("Could not find subdataset of name \"" + datasetName + "\"");
            }
            group = dataset.getGroupsMap().get(groupName);
        }
        return group;
    }

    private void assignGroupsToDatasets() throws JRException {
        for (JRDesignElementDataset jRDesignElementDataset : this.groupBoundDatasets) {
            JRGroup group;
            String groupName;
            Map<String, JRGroup> groupsMap;
            JRDatasetRun datasetRun = jRDesignElementDataset.getDatasetRun();
            if (datasetRun == null) {
                groupsMap = this.jasperDesign.getGroupsMap();
            } else {
                String datasetName;
                Map<String, JRDataset> datasetMap = this.jasperDesign.getDatasetMap();
                JRDesignDataset subDataset = (JRDesignDataset)datasetMap.get(datasetName = datasetRun.getDatasetName());
                if (subDataset == null) {
                    throw new JRException("Unknown sub dataset '" + datasetName + "' for chart dataset.");
                }
                groupsMap = subDataset.getGroupsMap();
            }
            if (jRDesignElementDataset.getIncrementTypeValue() == IncrementTypeEnum.GROUP) {
                groupName = null;
                group = jRDesignElementDataset.getIncrementGroup();
                if (group != null) {
                    groupName = group.getName();
                    group = groupsMap.get(group.getName());
                }
                if (!this.ignoreConsistencyProblems && group == null) {
                    throw new JRValidationException("Unknown increment group '" + groupName + "' for chart dataset.", jRDesignElementDataset);
                }
                jRDesignElementDataset.setIncrementGroup(group);
            } else {
                jRDesignElementDataset.setIncrementGroup(null);
            }
            if (jRDesignElementDataset.getResetTypeValue() == ResetTypeEnum.GROUP) {
                groupName = null;
                group = jRDesignElementDataset.getResetGroup();
                if (group != null) {
                    groupName = group.getName();
                    group = groupsMap.get(group.getName());
                }
                if (!this.ignoreConsistencyProblems && group == null) {
                    throw new JRValidationException("Unknown reset group '" + groupName + "' for chart dataset.", jRDesignElementDataset);
                }
                jRDesignElementDataset.setResetGroup(group);
                continue;
            }
            jRDesignElementDataset.setResetGroup(null);
        }
    }

    public void addError(Exception e2) {
        if (!this.ignoreConsistencyProblems) {
            this.errors.add(e2);
        }
    }

    public boolean isIgnoreConsistencyProblems() {
        return this.ignoreConsistencyProblems;
    }

    public void setIgnoreConsistencyProblems(boolean ignoreConsistencyProblems) {
        this.ignoreConsistencyProblems = ignoreConsistencyProblems;
    }

    public void pushReportContext(XmlLoaderReportContext context) {
        this.contextStack.addFirst(context);
    }

    public XmlLoaderReportContext popReportContext() {
        return this.contextStack.removeFirst();
    }

    public XmlLoaderReportContext getReportContext() {
        return this.contextStack.isEmpty() ? null : this.contextStack.getFirst();
    }
}

