/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.exceptions.BadPasswordException;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;

class PdfCopyFieldsImp
extends PdfWriter {
    private static final PdfName iTextTag = new PdfName("_iTextTag_");
    private static final Integer zero = new Integer(0);
    ArrayList<PdfReader> readers = new ArrayList();
    HashMap<PdfReader, IntHashtable> readers2intrefs = new HashMap();
    HashMap<PdfReader, IntHashtable> pages2intrefs = new HashMap();
    HashMap<PdfReader, IntHashtable> visited = new HashMap();
    ArrayList<AcroFields> fields = new ArrayList();
    RandomAccessFileOrArray file;
    HashMap<String, Object> fieldTree = new HashMap();
    ArrayList<PdfIndirectReference> pageRefs = new ArrayList();
    ArrayList<PdfDictionary> pageDics = new ArrayList();
    PdfDictionary resources = new PdfDictionary();
    PdfDictionary form;
    boolean closing = false;
    Document nd;
    private HashMap<PdfArray, ArrayList<Integer>> tabOrder;
    private ArrayList<String> calculationOrder = new ArrayList();
    private ArrayList<Object> calculationOrderRefs;
    private boolean hasSignature;
    protected static final HashMap<PdfName, Integer> widgetKeys = new HashMap();
    protected static final HashMap<PdfName, Integer> fieldKeys = new HashMap();

    static {
        Integer one = new Integer(1);
        widgetKeys.put(PdfName.SUBTYPE, one);
        widgetKeys.put(PdfName.CONTENTS, one);
        widgetKeys.put(PdfName.RECT, one);
        widgetKeys.put(PdfName.NM, one);
        widgetKeys.put(PdfName.M, one);
        widgetKeys.put(PdfName.F, one);
        widgetKeys.put(PdfName.BS, one);
        widgetKeys.put(PdfName.BORDER, one);
        widgetKeys.put(PdfName.AP, one);
        widgetKeys.put(PdfName.AS, one);
        widgetKeys.put(PdfName.C, one);
        widgetKeys.put(PdfName.A, one);
        widgetKeys.put(PdfName.STRUCTPARENT, one);
        widgetKeys.put(PdfName.OC, one);
        widgetKeys.put(PdfName.H, one);
        widgetKeys.put(PdfName.MK, one);
        widgetKeys.put(PdfName.DA, one);
        widgetKeys.put(PdfName.Q, one);
        fieldKeys.put(PdfName.AA, one);
        fieldKeys.put(PdfName.FT, one);
        fieldKeys.put(PdfName.TU, one);
        fieldKeys.put(PdfName.TM, one);
        fieldKeys.put(PdfName.FF, one);
        fieldKeys.put(PdfName.V, one);
        fieldKeys.put(PdfName.DV, one);
        fieldKeys.put(PdfName.DS, one);
        fieldKeys.put(PdfName.RV, one);
        fieldKeys.put(PdfName.OPT, one);
        fieldKeys.put(PdfName.MAXLEN, one);
        fieldKeys.put(PdfName.TI, one);
        fieldKeys.put(PdfName.I, one);
        fieldKeys.put(PdfName.LOCK, one);
        fieldKeys.put(PdfName.SV, one);
    }

    PdfCopyFieldsImp(OutputStream os) throws DocumentException {
        this(os, '\u0000');
    }

    PdfCopyFieldsImp(OutputStream os, char pdfVersion) throws DocumentException {
        super(new PdfDocument(), os);
        this.pdf.addWriter(this);
        if (pdfVersion != '\u0000') {
            super.setPdfVersion(pdfVersion);
        }
        this.nd = new Document();
        this.nd.addDocListener(this.pdf);
    }

    void addDocument(PdfReader reader, List<Integer> pagesToKeep) throws DocumentException, IOException {
        if (!this.readers2intrefs.containsKey(reader) && reader.isTampered()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("the.document.was.reused"));
        }
        reader = new PdfReader(reader);
        reader.selectPages(pagesToKeep);
        if (reader.getNumberOfPages() == 0) {
            return;
        }
        reader.setTampered(false);
        this.addDocument(reader);
    }

    void addDocument(PdfReader reader) throws DocumentException, IOException {
        if (!reader.isOpenedWithFullPermissions()) {
            throw new BadPasswordException(MessageLocalization.getComposedMessage("pdfreader.not.opened.with.owner.password"));
        }
        this.openDoc();
        if (this.readers2intrefs.containsKey(reader)) {
            reader = new PdfReader(reader);
        } else {
            if (reader.isTampered()) {
                throw new DocumentException(MessageLocalization.getComposedMessage("the.document.was.reused"));
            }
            reader.consolidateNamedDestinations();
            reader.setTampered(true);
        }
        reader.shuffleSubsetNames();
        this.readers2intrefs.put(reader, new IntHashtable());
        this.readers.add(reader);
        int len = reader.getNumberOfPages();
        IntHashtable refs = new IntHashtable();
        int p2 = 1;
        while (p2 <= len) {
            refs.put(reader.getPageOrigRef(p2).getNumber(), 1);
            reader.releasePage(p2);
            ++p2;
        }
        this.pages2intrefs.put(reader, refs);
        this.visited.put(reader, new IntHashtable());
        this.fields.add(reader.getAcroFields());
        this.updateCalculationOrder(reader);
    }

    private static String getCOName(PdfReader reader, PRIndirectReference ref) {
        String name = "";
        while (ref != null) {
            PdfObject obj = PdfReader.getPdfObject(ref);
            if (obj == null || obj.type() != 6) break;
            PdfDictionary dic = (PdfDictionary)obj;
            PdfString t2 = dic.getAsString(PdfName.T);
            if (t2 != null) {
                name = String.valueOf(t2.toUnicodeString()) + "." + name;
            }
            ref = (PRIndirectReference)dic.get(PdfName.PARENT);
        }
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    protected void updateCalculationOrder(PdfReader reader) {
        PdfDictionary catalog = reader.getCatalog();
        PdfDictionary acro = catalog.getAsDict(PdfName.ACROFORM);
        if (acro == null) {
            return;
        }
        PdfArray co = acro.getAsArray(PdfName.CO);
        if (co == null || co.size() == 0) {
            return;
        }
        AcroFields af = reader.getAcroFields();
        int k2 = 0;
        while (k2 < co.size()) {
            String name;
            PdfObject obj = co.getPdfObject(k2);
            if (obj != null && obj.isIndirect() && af.getFieldItem(name = PdfCopyFieldsImp.getCOName(reader, (PRIndirectReference)obj)) != null && !this.calculationOrder.contains(name = "." + name)) {
                this.calculationOrder.add(name);
            }
            ++k2;
        }
    }

    void propagate(PdfObject obj, PdfIndirectReference refo, boolean restricted) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof PdfIndirectReference) {
            return;
        }
        switch (obj.type()) {
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                for (PdfName key : dic.getKeys()) {
                    if (restricted && (key.equals(PdfName.PARENT) || key.equals(PdfName.KIDS))) continue;
                    PdfObject ob = dic.get(key);
                    if (ob != null && ob.isIndirect()) {
                        PRIndirectReference ind = (PRIndirectReference)ob;
                        if (this.setVisited(ind) || this.isPage(ind)) continue;
                        PdfIndirectReference ref = this.getNewReference(ind);
                        this.propagate(PdfReader.getPdfObjectRelease(ind), ref, restricted);
                        continue;
                    }
                    this.propagate(ob, null, restricted);
                }
                break;
            }
            case 5: {
                ListIterator<PdfObject> it = ((PdfArray)obj).listIterator();
                while (it.hasNext()) {
                    PdfObject ob = (PdfObject)it.next();
                    if (ob != null && ob.isIndirect()) {
                        PRIndirectReference ind = (PRIndirectReference)ob;
                        if (this.isVisited(ind) || this.isPage(ind)) continue;
                        PdfIndirectReference ref = this.getNewReference(ind);
                        this.propagate(PdfReader.getPdfObjectRelease(ind), ref, restricted);
                        continue;
                    }
                    this.propagate(ob, null, restricted);
                }
                break;
            }
            case 10: {
                throw new RuntimeException(MessageLocalization.getComposedMessage("reference.pointing.to.reference"));
            }
        }
    }

    private void adjustTabOrder(PdfArray annots, PdfIndirectReference ind, PdfNumber nn) {
        int v2 = nn.intValue();
        ArrayList<Integer> t2 = this.tabOrder.get(annots);
        if (t2 == null) {
            t2 = new ArrayList();
            int size = annots.size() - 1;
            int k2 = 0;
            while (k2 < size) {
                t2.add(zero);
                ++k2;
            }
            t2.add(new Integer(v2));
            this.tabOrder.put(annots, t2);
            annots.add(ind);
        } else {
            int size;
            int k3 = size = t2.size() - 1;
            while (k3 >= 0) {
                if (t2.get(k3) <= v2) {
                    t2.add(k3 + 1, new Integer(v2));
                    annots.add(k3 + 1, ind);
                    size = -2;
                    break;
                }
                --k3;
            }
            if (size != -2) {
                t2.add(0, new Integer(v2));
                annots.add(0, ind);
            }
        }
    }

    protected PdfArray branchForm(HashMap<String, Object> level, PdfIndirectReference parent, String fname) throws IOException {
        PdfArray arr = new PdfArray();
        for (Map.Entry<String, Object> entry : level.entrySet()) {
            String name = entry.getKey();
            Object obj = entry.getValue();
            PdfIndirectReference ind = this.getPdfIndirectReference();
            PdfDictionary dic = new PdfDictionary();
            if (parent != null) {
                dic.put(PdfName.PARENT, parent);
            }
            dic.put(PdfName.T, new PdfString(name, "UnicodeBig"));
            String fname2 = String.valueOf(fname) + "." + name;
            int coidx = this.calculationOrder.indexOf(fname2);
            if (coidx >= 0) {
                this.calculationOrderRefs.set(coidx, ind);
            }
            if (obj instanceof HashMap) {
                dic.put(PdfName.KIDS, this.branchForm((HashMap)obj, ind, fname2));
                arr.add(ind);
                this.addToBody((PdfObject)dic, ind);
                continue;
            }
            ArrayList list = (ArrayList)obj;
            dic.mergeDifferent((PdfDictionary)list.get(0));
            if (list.size() == 3) {
                dic.mergeDifferent((PdfDictionary)list.get(2));
                int page = (Integer)list.get(1);
                PdfDictionary pageDic = this.pageDics.get(page - 1);
                PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
                if (annots == null) {
                    annots = new PdfArray();
                    pageDic.put(PdfName.ANNOTS, annots);
                }
                PdfNumber nn = (PdfNumber)dic.get(iTextTag);
                dic.remove(iTextTag);
                this.adjustTabOrder(annots, ind, nn);
            } else {
                PdfArray kids = new PdfArray();
                int k2 = 1;
                while (k2 < list.size()) {
                    int page = (Integer)list.get(k2);
                    PdfDictionary pageDic = this.pageDics.get(page - 1);
                    PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
                    if (annots == null) {
                        annots = new PdfArray();
                        pageDic.put(PdfName.ANNOTS, annots);
                    }
                    PdfDictionary widget = new PdfDictionary();
                    widget.merge((PdfDictionary)list.get(k2 + 1));
                    widget.put(PdfName.PARENT, ind);
                    PdfNumber nn = (PdfNumber)widget.get(iTextTag);
                    widget.remove(iTextTag);
                    PdfIndirectReference wref = this.addToBody(widget).getIndirectReference();
                    this.adjustTabOrder(annots, wref, nn);
                    kids.add(wref);
                    this.propagate(widget, null, false);
                    k2 += 2;
                }
                dic.put(PdfName.KIDS, kids);
            }
            arr.add(ind);
            this.addToBody((PdfObject)dic, ind);
            this.propagate(dic, null, false);
        }
        return arr;
    }

    protected void createAcroForms() throws IOException {
        if (this.fieldTree.isEmpty()) {
            return;
        }
        this.form = new PdfDictionary();
        this.form.put(PdfName.DR, this.resources);
        this.propagate(this.resources, null, false);
        this.form.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        this.tabOrder = new HashMap();
        this.calculationOrderRefs = new ArrayList<String>(this.calculationOrder);
        this.form.put(PdfName.FIELDS, this.branchForm(this.fieldTree, null, ""));
        if (this.hasSignature) {
            this.form.put(PdfName.SIGFLAGS, new PdfNumber(3));
        }
        PdfArray co = new PdfArray();
        int k2 = 0;
        while (k2 < this.calculationOrderRefs.size()) {
            Object obj = this.calculationOrderRefs.get(k2);
            if (obj instanceof PdfIndirectReference) {
                co.add((PdfIndirectReference)obj);
            }
            ++k2;
        }
        if (co.size() > 0) {
            this.form.put(PdfName.CO, co);
        }
    }

    @Override
    public void close() {
        if (this.closing) {
            super.close();
            return;
        }
        this.closing = true;
        try {
            this.closeIt();
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    protected void closeIt() throws IOException {
        int page;
        PdfReader reader;
        int k2 = 0;
        while (k2 < this.readers.size()) {
            this.readers.get(k2).removeFields();
            ++k2;
        }
        int r2 = 0;
        while (r2 < this.readers.size()) {
            reader = this.readers.get(r2);
            page = 1;
            while (page <= reader.getNumberOfPages()) {
                this.pageRefs.add(this.getNewReference(reader.getPageOrigRef(page)));
                this.pageDics.add(reader.getPageN(page));
                ++page;
            }
            ++r2;
        }
        this.mergeFields();
        this.createAcroForms();
        r2 = 0;
        while (r2 < this.readers.size()) {
            reader = this.readers.get(r2);
            page = 1;
            while (page <= reader.getNumberOfPages()) {
                PdfDictionary dic = reader.getPageN(page);
                PdfIndirectReference pageRef = this.getNewReference(reader.getPageOrigRef(page));
                PdfIndirectReference parent = this.root.addPageRef(pageRef);
                dic.put(PdfName.PARENT, parent);
                this.propagate(dic, pageRef, false);
                ++page;
            }
            ++r2;
        }
        for (Map.Entry<PdfReader, IntHashtable> entry : this.readers2intrefs.entrySet()) {
            PdfReader reader2 = entry.getKey();
            try {
                this.file = reader2.getSafeFile();
                this.file.reOpen();
                IntHashtable t2 = entry.getValue();
                int[] keys = t2.toOrderedKeys();
                int k3 = 0;
                while (k3 < keys.length) {
                    PRIndirectReference ref = new PRIndirectReference(reader2, keys[k3]);
                    this.addToBody(PdfReader.getPdfObjectRelease(ref), t2.get(keys[k3]));
                    ++k3;
                }
            }
            finally {
                try {
                    this.file.close();
                    reader2.close();
                }
                catch (Exception exception) {}
            }
        }
        this.pdf.close();
    }

    void addPageOffsetToField(HashMap<String, AcroFields.Item> fd, int pageOffset) {
        if (pageOffset == 0) {
            return;
        }
        for (AcroFields.Item item : fd.values()) {
            int k2 = 0;
            while (k2 < item.size()) {
                int p2 = item.getPage(k2);
                item.forcePage(k2, p2 + pageOffset);
                ++k2;
            }
        }
    }

    void createWidgets(ArrayList<Object> list, AcroFields.Item item) {
        int k2 = 0;
        while (k2 < item.size()) {
            list.add(item.getPage(k2));
            PdfDictionary merged = item.getMerged(k2);
            PdfObject dr = merged.get(PdfName.DR);
            if (dr != null) {
                PdfFormField.mergeResources(this.resources, (PdfDictionary)PdfReader.getPdfObject(dr));
            }
            PdfDictionary widget = new PdfDictionary();
            for (PdfName element : merged.getKeys()) {
                PdfName key = element;
                if (!widgetKeys.containsKey(key)) continue;
                widget.put(key, merged.get(key));
            }
            widget.put(iTextTag, new PdfNumber(item.getTabOrder(k2) + 1));
            list.add(widget);
            ++k2;
        }
    }

    void mergeField(String name, AcroFields.Item item) {
        HashMap obj;
        String s2;
        HashMap<String, Object> map;
        block16: {
            map = this.fieldTree;
            StringTokenizer tk = new StringTokenizer(name, ".");
            if (!tk.hasMoreTokens()) {
                return;
            }
            while (true) {
                s2 = tk.nextToken();
                obj = map.get(s2);
                if (!tk.hasMoreTokens()) break block16;
                if (obj == null) {
                    obj = new HashMap();
                    map.put(s2, obj);
                    map = obj;
                    continue;
                }
                if (!(obj instanceof HashMap)) break;
                map = obj;
            }
            return;
        }
        if (obj instanceof HashMap) {
            return;
        }
        PdfDictionary merged = item.getMerged(0);
        if (obj == null) {
            PdfDictionary field = new PdfDictionary();
            if (PdfName.SIG.equals(merged.get(PdfName.FT))) {
                this.hasSignature = true;
            }
            for (PdfName element : merged.getKeys()) {
                PdfName key = element;
                if (!fieldKeys.containsKey(key)) continue;
                field.put(key, merged.get(key));
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(field);
            this.createWidgets(list, item);
            map.put(s2, list);
        } else {
            ArrayList list = (ArrayList)((Object)obj);
            PdfDictionary field = (PdfDictionary)list.get(0);
            PdfName type1 = (PdfName)field.get(PdfName.FT);
            PdfName type2 = (PdfName)merged.get(PdfName.FT);
            if (type1 == null || !type1.equals(type2)) {
                return;
            }
            int flag1 = 0;
            PdfObject f1 = field.get(PdfName.FF);
            if (f1 != null && f1.isNumber()) {
                flag1 = ((PdfNumber)f1).intValue();
            }
            int flag2 = 0;
            PdfObject f2 = merged.get(PdfName.FF);
            if (f2 != null && f2.isNumber()) {
                flag2 = ((PdfNumber)f2).intValue();
            }
            if (type1.equals(PdfName.BTN)) {
                if (((flag1 ^ flag2) & 0x10000) != 0) {
                    return;
                }
                if ((flag1 & 0x10000) == 0 && ((flag1 ^ flag2) & 0x8000) != 0) {
                    return;
                }
            } else if (type1.equals(PdfName.CH) && ((flag1 ^ flag2) & 0x20000) != 0) {
                return;
            }
            this.createWidgets(list, item);
        }
    }

    void mergeWithMaster(HashMap<String, AcroFields.Item> fd) {
        for (Map.Entry<String, AcroFields.Item> entry : fd.entrySet()) {
            String name = entry.getKey();
            this.mergeField(name, entry.getValue());
        }
    }

    void mergeFields() {
        int pageOffset = 0;
        int k2 = 0;
        while (k2 < this.fields.size()) {
            HashMap<String, AcroFields.Item> fd = this.fields.get(k2).getFields();
            this.addPageOffsetToField(fd, pageOffset);
            this.mergeWithMaster(fd);
            pageOffset += this.readers.get(k2).getNumberOfPages();
            ++k2;
        }
    }

    @Override
    public PdfIndirectReference getPageReference(int page) {
        return this.pageRefs.get(page - 1);
    }

    @Override
    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) {
        try {
            PdfDocument.PdfCatalog cat = this.pdf.getCatalog(rootObj);
            if (this.form != null) {
                PdfIndirectReference ref = this.addToBody(this.form).getIndirectReference();
                cat.put(PdfName.ACROFORM, ref);
            }
            return cat;
        }
        catch (IOException e2) {
            throw new ExceptionConverter(e2);
        }
    }

    protected PdfIndirectReference getNewReference(PRIndirectReference ref) {
        return new PdfIndirectReference(0, this.getNewObjectNumber(ref.getReader(), ref.getNumber(), 0));
    }

    @Override
    protected int getNewObjectNumber(PdfReader reader, int number, int generation) {
        IntHashtable refs = this.readers2intrefs.get(reader);
        int n2 = refs.get(number);
        if (n2 == 0) {
            n2 = this.getIndirectReferenceNumber();
            refs.put(number, n2);
        }
        return n2;
    }

    protected boolean setVisited(PRIndirectReference ref) {
        IntHashtable refs = this.visited.get(ref.getReader());
        if (refs != null) {
            return refs.put(ref.getNumber(), 1) != 0;
        }
        return false;
    }

    protected boolean isVisited(PRIndirectReference ref) {
        IntHashtable refs = this.visited.get(ref.getReader());
        if (refs != null) {
            return refs.containsKey(ref.getNumber());
        }
        return false;
    }

    protected boolean isVisited(PdfReader reader, int number, int generation) {
        IntHashtable refs = this.readers2intrefs.get(reader);
        return refs.containsKey(number);
    }

    protected boolean isPage(PRIndirectReference ref) {
        IntHashtable refs = this.pages2intrefs.get(ref.getReader());
        if (refs != null) {
            return refs.containsKey(ref.getNumber());
        }
        return false;
    }

    @Override
    RandomAccessFileOrArray getReaderFile(PdfReader reader) {
        return this.file;
    }

    public void openDoc() {
        if (!this.nd.isOpen()) {
            this.nd.open();
        }
    }
}

