/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import net.sf.jasperreports.engine.util.FormatUtils;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class JRXlsxDataSource
extends JRAbstractTextDataSource
implements JRRewindableDataSource {
    private Workbook workbook;
    private int sheetIndex;
    private DateFormat dateFormat = new SimpleDateFormat();
    private NumberFormat numberFormat = new DecimalFormat();
    private Map<String, Integer> columnNames = new LinkedHashMap<String, Integer>();
    private boolean useFirstRowAsHeader;
    private int recordIndex = -1;
    private InputStream inputStream;
    private boolean closeWorkbook;
    private boolean closeInputStream;

    public JRXlsxDataSource(Workbook workbook) {
        this.workbook = workbook;
        this.closeWorkbook = false;
    }

    public JRXlsxDataSource(InputStream is) throws JRException, IOException {
        try {
            this.inputStream = is;
            this.workbook = new XSSFWorkbook(is);
            this.closeWorkbook = true;
            this.closeInputStream = false;
        }
        catch (Exception e2) {
            throw new JRException(e2);
        }
    }

    public JRXlsxDataSource(File file) throws JRException, FileNotFoundException, IOException {
        this(new FileInputStream(file));
        this.closeInputStream = true;
    }

    public JRXlsxDataSource(JasperReportsContext jasperReportsContext, String location) throws JRException, IOException {
        this(RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(location));
        this.closeInputStream = true;
    }

    public JRXlsxDataSource(String location) throws JRException, IOException {
        this(DefaultJasperReportsContext.getInstance(), location);
    }

    @Override
    public boolean next() throws JRException {
        ++this.recordIndex;
        if (this.workbook != null) {
            if (this.recordIndex > this.workbook.getSheetAt(this.sheetIndex).getLastRowNum() && this.sheetIndex + 1 < this.workbook.getNumberOfSheets() && this.workbook.getSheetAt(this.sheetIndex + 1).getLastRowNum() > 0) {
                ++this.sheetIndex;
                this.recordIndex = -1;
                return this.next();
            }
            if (this.sheetIndex == 0 && this.useFirstRowAsHeader && this.recordIndex == 0) {
                this.readHeader();
                ++this.recordIndex;
            }
            if (this.recordIndex <= this.workbook.getSheetAt(this.sheetIndex).getLastRowNum()) {
                return true;
            }
            if (this.closeWorkbook) {
                // empty if block
            }
        }
        return false;
    }

    @Override
    public void moveFirst() {
        this.recordIndex = -1;
        this.sheetIndex = 0;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        Integer columnIndex = this.columnNames.get(fieldName);
        if (columnIndex == null && fieldName.startsWith("COLUMN_")) {
            columnIndex = Integer.valueOf(fieldName.substring(7));
        }
        if (columnIndex == null) {
            throw new JRException("Unknown column name : " + fieldName);
        }
        Sheet sheet = this.workbook.getSheetAt(this.sheetIndex);
        Cell cell = sheet.getRow(this.recordIndex).getCell(columnIndex.intValue());
        Class<?> valueClass = jrField.getValueClass();
        if (valueClass.equals(String.class)) {
            return cell.getStringCellValue();
        }
        try {
            if (valueClass.equals(Boolean.class)) {
                return cell.getBooleanCellValue();
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                if (this.numberFormat != null) {
                    return FormatUtils.getFormattedNumber(this.numberFormat, String.valueOf(cell.getNumericCellValue()), valueClass);
                }
                return this.convertStringValue(String.valueOf(cell.getNumericCellValue()), valueClass);
            }
            if (Date.class.isAssignableFrom(valueClass)) {
                if (this.dateFormat != null) {
                    return FormatUtils.getFormattedDate(this.dateFormat, String.valueOf(cell.getDateCellValue()), valueClass);
                }
                return this.convertStringValue(String.valueOf(cell.getDateCellValue()), valueClass);
            }
            throw new JRException("Field '" + jrField.getName() + "' is of class '" + valueClass.getName() + "' and can not be converted");
        }
        catch (Exception e2) {
            throw new JRException("Unable to get value for field '" + jrField.getName() + "' of class '" + valueClass.getName() + "'", e2);
        }
    }

    private void readHeader() {
        Sheet sheet = this.workbook.getSheetAt(0);
        if (this.columnNames.size() == 0) {
            Row row = sheet.getRow(this.recordIndex);
            for (int columnIndex = 0; columnIndex < row.getLastCellNum(); ++columnIndex) {
                Cell cell = row.getCell(columnIndex);
                if (cell != null) {
                    this.columnNames.put(cell.toString(), columnIndex);
                    continue;
                }
                this.columnNames.put("COLUMN_" + columnIndex, columnIndex);
            }
        } else {
            LinkedHashMap<String, Integer> newColumnNames = new LinkedHashMap<String, Integer>();
            for (Integer columnIndex : this.columnNames.values()) {
                Row row = sheet.getRow(this.recordIndex);
                Cell cell = row.getCell(columnIndex.intValue());
                if (cell == null) continue;
                newColumnNames.put(cell.toString(), columnIndex);
            }
            this.columnNames = newColumnNames;
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.checkReadStarted();
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.checkReadStarted();
        this.numberFormat = numberFormat;
    }

    public void setColumnNames(String[] columnNames) {
        this.checkReadStarted();
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            this.columnNames.put(columnNames[i2], i2);
        }
    }

    public void setColumnNames(String[] columnNames, int[] columnIndexes) {
        this.checkReadStarted();
        if (columnNames.length != columnIndexes.length) {
            throw new JRRuntimeException("The number of column names must be equal to the number of column indexes.");
        }
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            this.columnNames.put(columnNames[i2], columnIndexes[i2]);
        }
    }

    public void setColumnIndexes(Integer[] columnIndexes) {
        this.checkReadStarted();
        for (int i2 = 0; i2 < columnIndexes.length; ++i2) {
            this.columnNames.put("COLUMN_" + i2, columnIndexes[i2]);
        }
    }

    public void setUseFirstRowAsHeader(boolean useFirstRowAsHeader) {
        this.checkReadStarted();
        this.useFirstRowAsHeader = useFirstRowAsHeader;
    }

    public void close() {
        try {
            if (this.closeInputStream) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkReadStarted() {
        if (this.recordIndex > 0) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started.");
        }
    }

    public Map<String, Integer> getColumnNames() {
        return this.columnNames;
    }
}

