/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.XalanXmlDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class XalanXPathQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(XalanXPathQueryExecuter.class);
    private final Document document = (Document)this.getParameterValue("XML_DATA_DOCUMENT");
    private final DocumentBuilderFactory documentBuilderFactory = (DocumentBuilderFactory)this.getParameterValue("DOCUMENT_BUILDER_FACTORY", true);
    private Map<String, String> namespacesMap = (Map)this.getParameterValue("XML_NAMESPACE_MAP", true);

    public XalanXPathQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        if (this.document == null) {
            log.warn("The supplied org.w3c.dom.Document object is null.");
        }
        this.parseQuery();
    }

    public XalanXPathQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return "XPath";
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        XalanXmlDataSource datasource = null;
        String xPath = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug("XPath query: " + xPath);
        }
        if (this.document != null && xPath != null) {
            if (this.namespacesMap == null) {
                this.namespacesMap = this.extractXmlNamespacesFromProperties();
            }
            datasource = new XalanXmlDataSource(this.document, xPath);
            datasource.setXmlNamespaceMap(this.namespacesMap);
            datasource.setDetectXmlNamespaces(this.getBooleanParameterOrProperty("net.sf.jasperreports.xml.detect.namespaces", false));
            datasource.setDocumentBuilderFactory(this.documentBuilderFactory);
            datasource.setLocale((Locale)this.getParameterValue("XML_LOCALE", true));
            datasource.setDatePattern((String)this.getParameterValue("XML_DATE_PATTERN", true));
            datasource.setNumberPattern((String)this.getParameterValue("XML_NUMBER_PATTERN", true));
            datasource.setTimeZone((TimeZone)this.getParameterValue("XML_TIME_ZONE", true));
        }
        return datasource;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }

    private Map<String, String> extractXmlNamespacesFromProperties() throws JRException {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        String xmlnsPrefix = "net.sf.jasperreports.xml.namespace.";
        List<JRPropertiesUtil.PropertySuffix> nsProperties = JRPropertiesUtil.getProperties(this.dataset, xmlnsPrefix);
        for (int i2 = 0; i2 < nsProperties.size(); ++i2) {
            JRPropertiesUtil.PropertySuffix prop = nsProperties.get(i2);
            String nsPrefix = prop.getKey().substring(xmlnsPrefix.length());
            if (nsPrefix.length() <= 0) continue;
            namespaces.put(nsPrefix, prop.getValue());
        }
        return namespaces.size() > 0 ? namespaces : null;
    }
}

