/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.BaseSaxParserFactory;
import net.sf.jasperreports.engine.xml.XmlHandlerNamespace;
import net.sf.jasperreports.engine.xml.XmlValueHandler;
import net.sf.jasperreports.engine.xml.XmlValueHandlerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrintSaxParserFactory
extends BaseSaxParserFactory {
    private static final Log log = LogFactory.getLog(PrintSaxParserFactory.class);
    public static final String EXPORT_XML_VALIDATION = "net.sf.jasperreports.export.xml.validation";

    @Override
    protected boolean isValidating() {
        return JRProperties.getBooleanProperty(EXPORT_XML_VALIDATION);
    }

    @Override
    protected List<String> getSchemaLocations() {
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(this.getResourceURI("net/sf/jasperreports/engine/dtds/jasperprint.xsd"));
        schemas.add(this.getResourceURI("net/sf/jasperreports/engine/dtds/jasperprint-dtd-compat.xsd"));
        List<XmlValueHandler> handlers = XmlValueHandlerUtils.instance().getHandlers();
        for (XmlValueHandler handler : handlers) {
            XmlHandlerNamespace namespace = handler.getNamespace();
            if (namespace == null) continue;
            String schemaResource = namespace.getInternalSchemaResource();
            String schemaURI = schemaResource != null ? this.getResourceURI(schemaResource) : namespace.getPublicSchemaLocation();
            if (log.isDebugEnabled()) {
                log.debug("Adding schema at " + schemaURI);
            }
            schemas.add(schemaURI);
        }
        return schemas;
    }
}

